% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpPlotMarkers.R
\name{kpPlotMarkers}
\alias{kpPlotMarkers}
\title{kpPlotMarkers}
\usage{
kpPlotMarkers(karyoplot, data=NULL, chr=NULL, x=NULL, y=0.75, labels=NULL, 
                     adjust.label.position=TRUE,  ignore.chromosome.ends=FALSE,
                     label.margin=0.001, max.iter=150, label.dist=0.001,
                     marker.parts = c(0.8,0.1, 0.1), text.orientation ="vertical",
                     ymin=NULL, ymax=NULL, data.panel=1, r0=NULL, r1=NULL,
                     line.color="black", label.color="black",
                     pos=NULL, srt=NULL, offset=NULL, clipping=TRUE, ...)
}
\arguments{
\item{karyoplot}{(a \code{KaryoPlot} object) This is the first argument to all data plotting functions of \code{karyoploteR}. A KaryoPlot object referring to the currently active plot.}

\item{data}{(a \code{GRanges}) A GRanges object with the data. If \code{data} is present, \code{chr} will be set to \code{seqnames(data)} and \code{x} to the midpoints of the rages in data. If no parameter \code{y} is specified and \code{data} has a column named \code{y} or \code{value} this column will be used to define the \code{y} value of each data point. (defaults to NULL)}

\item{chr}{(a charecter vector) A vector of chromosome names specifying the chromosomes of the data points. If \code{data} is not NULL, \code{chr} is ignored. (defaults to NULL)}

\item{x}{(a numeric vector) A numeric vector with the positions (in base pairs) of the data points in the chromosomes. If \code{data} is not NULL, \code{x} is ignored. (defaults to NULL)}

\item{y}{(a numeric vector) A numeric vector with the values of the data points. If \code{y} is not NULL, it is used instead of any data column in \code{data}. (defaults to 0.75)}

\item{labels}{(a character vector) The labels to be plotted. (defaults to NULL)}

\item{adjust.label.position}{(logical) whether to adjust the label positions to avoid label overlapping (defaults to TRUE)}

\item{ignore.chromosome.ends}{(logical) If TRUE, when adjusting label position marker labels can move beyond the chromosome ends. (defaults to FALSE, do not move out of origin chromosome)}

\item{label.margin}{(numeric) The vertical margin to leave between the ens of the marker line and the marker label. In plot coordinates. (defaults to 0.001)}

\item{max.iter}{(numeric) The maximum number of iterations in the iterative algorithm to adjust the label positioning. (defaults to 150)}

\item{label.dist}{(numeric) The minimum distance between labels to consider them as non-overlapping (defaults to 0.001)}

\item{marker.parts}{(numeruc vector of three elements) The portion of the distance between 0 and y to be filled with a: vertical, diagonal of vertical part of the marker line. (defaults to c(0.8,0.1,0.1), long vertical stem, small diagonal and small vertical on top)}

\item{text.orientation}{("vertical" or "horizontal) How should the text be plotted. Forced values of srt and pos take precedence. (defaults to "vertical")}

\item{ymin}{(numeric) The minimum value of \code{y} to be plotted. If NULL, it is set to the min value of the selected data panel. (defaults to NULL)}

\item{ymax}{(numeric) The maximum value of \code{y} to be plotted. If NULL, it is set to the max value of the selected data panel. (defaults to NULL)}

\item{data.panel}{(numeric) The identifier of the data panel where the data is to be plotted. The available data panels depend on the plot type selected in the call to \code{\link{plotKaryotype}}. (defaults to 1)}

\item{r0}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{r1}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{line.color}{(color) The color of marker line. (defaults to "black")}

\item{label.color}{(color) The color of the label (defaults to "black")}

\item{pos}{(1,2,3,4) The standard pos graphical parameter. If NULL, it's automatically set depending on "text.orientation". (defaults to NULL)}

\item{srt}{(numeric) The standard srt graphical parameter. If NULL, it's automatically set depending on "text.orientation". (defaults to NULL)}

\item{offset}{(numeric) The standard offset graphical parameter. If NULL, it's automatically set depending on "text.orientation". (defaults to NULL)}

\item{clipping}{(boolean) Only used if zooming is active. If TRUE, the data representation will be not drawn out of the drawing area (i.e. in margins, etc) even if the data overflows the drawing area. If FALSE, the data representation may overflow into the margins of the plot. (defaults to TRUE)}

\item{...}{The ellipsis operator can be used to specify any additional graphical parameters. Any additional parameter will be passed to the internal calls to the R base plotting functions.}
}
\value{
Returns the original karyoplot object with the data computed (adjusted label positioning) stored at \code{karyoplot$latest.plot}
}
\description{
Plots markers on the genome as a line with a label on top.
}
\details{
This function plots markers on the genome. It implements an interative
algorithm to avoid ovelapping between the labels of different markers. Since
labels might be plotted in a different position than the original points, 
a line with three parts (a vertical, a diagonal and another vertical) is 
plotted to link the label with the original position. It is possible to plot
labels in horizontal or vertical text and to specify different colors for the
marker line and label.

There's more information at the \url{https://bernatgel.github.io/karyoploter_tutorial/}{karyoploteR tutorial}.
}
\note{
The iterative algorithm is not guaranteed to suceed and might end up
with overlapping labels if labels are too dense or if too few iterations 
allowed. With many markers, the algorithm might be slow.
}
\examples{
 

data <- toGRanges(data.frame(c("chr1", "chr1", "chr1"), c(20e6, 21e6, 22e6), c(20.01e6, 21.01e6, 22.01e6), labels=c("GeneA", "GeneB", "GeneC")))

kp <- plotKaryotype("hg19", plot.type=1, chromosomes = "chr1", main="Default markers")
kpPlotMarkers(kp, data)

kp <- plotKaryotype("hg19", plot.type=2, chromosomes = "chr1", main="Markers Horizontal")
kpPlotMarkers(kp, data, text.orientation = "horizontal")
kpPlotMarkers(kp, data, text.orientation = "horizontal", label.dist = 0.02, data.panel=2)

kp <- plotKaryotype("hg19", plot.type=2, chromosomes = "chr1", main="Different Marker parts")
kpPlotMarkers(kp, data, text.orientation = "horizontal", marker.parts=c(0, 1, 0), line.color="red")
kpPlotMarkers(kp, data, text.orientation = "horizontal", marker.parts=c(0.1, 0.2, 0.4), label.dist = 0.02, data.panel=2, label.color="blue")


 
}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpLines}}, \code{\link{kpText}}
}
