% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpPlotLoess.R
\name{kpPlotLoess}
\alias{kpPlotLoess}
\title{kpPlotLoess}
\usage{
kpPlotLoess(karyoplot, data=NULL, chr=NULL, x=NULL, y=NULL, conf.interval=0.95, span=0.5, data.panel=1, r0=NULL, r1=NULL, ymin=NULL, ymax=NULL, col="black", lty=1, lwd=1, ci.col="#888888AA", ci.border=NA, ci.border.lty=1, ci.border.lwd=1, clipping=TRUE, ...)
}
\arguments{
\item{karyoplot}{(a \code{KaryoPlot} object) This is the first argument to all data plotting functions of \code{karyoploteR}. A KaryoPlot object referring to the currently active plot.}

\item{data}{(a \code{GRanges}) A GRanges object with the data. If \code{data} is present, \code{chr} will be set to \code{seqnames(data)} and \code{x} to the midpoints of the rages in data. If no parameter \code{y} is specified and \code{data} has a column named \code{y} or \code{value} this column will be used to define the \code{y} value of each data point. (defaults to NULL)}

\item{chr}{(a charecter vector) A vector of chromosome names specifying the chromosomes of the data points. If \code{data} is not NULL, \code{chr} is ignored. (defaults to NULL)}

\item{x}{(a numeric vector) A numeric vector with the positions (in base pairs) of the data points in the chromosomes. If \code{data} is not NULL, \code{x} is ignored. (defaults to NULL)}

\item{y}{(a numeric vector) A numeric vector with the values of the data points. If \code{y} is not NULL, it is used instead of any data column in \code{data}. (defaults to NULL)}

\item{conf.interval}{The confidence interval to plot. If a number in (0,1), the confidence interval is plotted. Else, no confidence interval is plotted. (defaults to 0.95)}

\item{span}{A parameter to control the smoothing level. It is passed to underlying function \code{\link[stats]{loess}}. (deafults to 0.5)}

\item{data.panel}{(numeric) The identifier of the data panel where the data is to be plotted. The available data panels depend on the plot type selected in the call to \code{\link{plotKaryotype}}. (defaults to 1)}

\item{r0}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{r1}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{ymin}{(numeric) The minimum value of \code{y} to be plotted. If NULL, it is set to the min value of the selected data panel. (defaults to NULL)}

\item{ymax}{(numeric) The maximum value of \code{y} to be plotted. If NULL, it is set to the max value of the selected data panel. (defaults to NULL)}

\item{col}{The color of the fitting line. (defaults to "black")}

\item{lty}{The line type (dashed, dotted...) of the fitting line (defaults to 1, solid)}

\item{lwd}{The line width of the fitting line (defaults to 1)}

\item{ci.col}{The color of the area representing the confidence interval. If NA no CI is plotted. (defaults to #888888AA, transparent gray)}

\item{ci.border}{The color of line marking the border of the confidence interval. If NA, it's not plotted. (defaults to NA)}

\item{ci.border.lty}{The line type of line marking the border of the confidence interval. (defaults to 1, solid)}

\item{ci.border.lwd}{The line width of line marking the border of the confidence interval. (defaults to 1)}

\item{clipping}{(boolean) Only used if zooming is active. If TRUE, the data representation will be not drawn out of the drawing area (i.e. in margins, etc) even if the data overflows the drawing area. If FALSE, the data representation may overflow into the margins of the plot. (defaults to TRUE)}

\item{...}{The ellipsis operator can be used to specify any additional graphical parameters. Any additional parameter will be passed to the internal calls to the R base plotting functions.}
}
\value{
Returns the original karyoplot object, unchanged.
}
\description{
Plot a LOESS smoothed line with confidence intervals given a list of points.
}
\details{
Given a set of data points (specified in any way accepted by \code{\link{kpPoints}}),
plot a LOESS smoothed line with optional confidence intervals. LOESS is
computed independently per each chromosome and data points are sorted before
fitting. It is possible to adjust the confidence interval with 
\code{conf.interval} and setting it to NULL or NA will plot no CI. It is also
possible to control the smoothing level with \code{span}. In addition to 
the standard plotting parameters, it is possible to control independently the
color of the fitting line and CI area and CI borders. It is also possible to
adjust the line type and line width of the fitting line and CI border.
}
\examples{


set.seed(1000)

dd <- data.frame(chr="chr1", x=1:48*5e6, y=rnorm(n=48, 0.5, 0.1 ))

kp <- plotKaryotype(chromosomes="chr1")
kpPoints(kp, chr=dd$chr, x=dd$x, y=dd$y)
kpPlotLoess(kp, chr=dd$chr, x=dd$x, y=dd$y, col="red", conf.interval = 0.99, ci.col = "#FAAAAAAA")


}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpPoints}}, \code{\link{kpLines}}, \code{\link{kpPlotRibbon}}
}
