% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpBars.R
\name{kpBars}
\alias{kpBars}
\title{kpBars}
\usage{
kpBars(karyoplot, data=NULL, chr=NULL, x0=NULL, x1=x0, y1=NULL, y0=NULL, ymin=NULL, ymax=NULL, data.panel=1, r0=NULL, r1=NULL, clipping=TRUE, ...)
}
\arguments{
\item{karyoplot}{(a \code{KaryoPlot} object) This is the first argument to all data plotting functions of \code{karyoploteR}. A KaryoPlot object referring to the currently active plot.}

\item{data}{(a \code{GRanges}) A GRanges object with the data. If \code{data} is present, \code{chr} will be set to \code{seqnames(data)}, \code{x0} to \code{start(data)} and x1 to \code{end(data)}. If no parameter \code{y0} is specified and \code{data} has a column named \code{y0}, this column will be used. The same for \code{y1}. (defaults to NULL)}

\item{chr}{(a charecter vector) A vector of chromosome names specifying the chromosomes of the data points. If \code{data} is not NULL, \code{chr} is ignored. (defaults to NULL)}

\item{x0}{(a numeric vector) A numeric vector of x left positions (in base pairs). If \code{data} is not NULL, \code{x0}. (defaults to NULL)}

\item{x1}{(a numeric vector) A numeric vector of x right positions (in base pairs). If \code{data} is not NULL, \code{x1}. (defaults to NULL)}

\item{y1}{(a numeric vector) A numeric vector of y top positions. If \code{y} is not NULL, it is used instead of any data column in \code{data}. (defaults to NULL)}

\item{y0}{(a numeric vector) A numeric vector of y bottom positions. If \code{y} is not NULL, it is used instead of any data column in \code{data}. (defaults to NULL)}

\item{ymin}{(numeric) The minimum value of \code{y} to be plotted. If NULL, it is set to the min value of the selected data panel. (defaults to NULL)}

\item{ymax}{(numeric) The maximum value of \code{y} to be plotted. If NULL, it is set to the max value of the selected data panel. (defaults to NULL)}

\item{data.panel}{(numeric) The identifier of the data panel where the data is to be plotted. The available data panels depend on the plot type selected in the call to \code{\link{plotKaryotype}}. (defaults to 1)}

\item{r0}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{r1}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{clipping}{(boolean) Only used if zooming is active. If TRUE, the data representation will be not drawn out of the drawing area (i.e. in margins, etc) even if the data overflows the drawing area. If FALSE, the data representation may overflow into the margins of the plot. (defaults to TRUE)}

\item{...}{The ellipsis operator can be used to specify any additional graphical parameters. Any additional parameter will be passed to the internal calls to the R base plotting functions.}
}
\value{
Returns the original karyoplot object, unchanged.
}
\description{
Plot bars along the genome
}
\details{
\code{kpBars} plots bars (rectangles) along the genome. It is very similar to 
\code{\link{kpRect}} except that if \code{y0} is missing, it's automatically set 
to \code{ymin} so all bars start from the base of the plotting region.
}
\examples{


set.seed(1000)

data <- toGRanges(data.frame(chr="chr1", start=10000000*(0:23), end=10000000*(1:24)))
y1 <- ((sin(start(data)) + rnorm(n=24, mean=0, sd=0.1))/5)+0.5
y0 <- y1 - rnorm(n=24, mean = 0, sd = 0.15)
 
kp <- plotKaryotype("hg19", plot.type=2, chromosomes=c("chr1", "chr2"))

#We can specify all data values separately. If missing y0, it defaults to ymin
kpBars(kp, chr=as.character(seqnames(data)), x0=start(data), x1=end(data), y1=y1,
       col="#FFBBBB", border="#EEAAAA")
kpLines(kp, data=data, y=y1, col="red")

#or we can provide all data into a single GRanges object
mcols(data) <- data.frame(y0=y0, y1=y1)
kpBars(kp, data[data$y0>data$y1], col="orange", border="orange", data.panel=2)
kpBars(kp, data[data$y0<=data$y1], col="purple", border="purple", data.panel=2)

kpLines(kp, data, y=data$y1, data.panel=2, col="red")
kpLines(kp, data, y=data$y0, data.panel=2, col="blue")

kpAxis(kp, data.panel = 1, cex=0.8, numticks = 5, col="#777777")
kpAxis(kp, data.panel = 2, cex=0.8, numticks = 5, col="#777777")

}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpRect}}, \code{\link{kpLines}}
}
