% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpAddMainTitle.R
\name{kpAddMainTitle}
\alias{kpAddMainTitle}
\title{kpAddMainTitle}
\usage{
kpAddMainTitle(karyoplot, main=NULL, ...)
}
\arguments{
\item{karyoplot}{a \code{karyoplot} object returned by a call to \code{plotKaryotype}}

\item{main}{(character) the main title of the plot}

\item{...}{any additional parameter to be passed to the text plotting. All R base graphics params are passed along.}
}
\value{
invisibly returns the given karyoplot object
}
\description{
Plots the chromosome names in the karyoplot
}
\details{
Given a KaryoPlot object and a character string, plot the character strings
as the main title of the plot. This function is usually automatically
called by plotKaryotype unless.
}
\examples{

kp <- plotKaryotype(labels.plotter = NULL)
kpAddMainTitle(kp, col="red", srt=30)
 
}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{getMainTitleBoundingBox}}
}
