% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDataPanelBoundingBox.R
\name{getDataPanelBoundingBox}
\alias{getDataPanelBoundingBox}
\title{getDataPanelBoundingBox}
\usage{
getDataPanelBoundingBox(karyoplot, data.panel)
}
\arguments{
\item{karyoplot}{a \code{karyoplot} object returned by a call to \code{plotKaryotype}}

\item{data.panel}{a valid data panel name (i.e. 1, 2, "ideogram", "all")}
}
\value{
Returns a list with four elements (x0, x1, y0 and y1), each of them an 
integer with the plot coordinates for the data.panel
}
\description{
Return the bounding box of a data panel in plot coordinates
}
\details{
Given a KaryoPlot object and a data.panel name, return the region 
where the data panel is placed. The returned values are in plot
coordinates, that is, the coord.change.function has been applied.
}
\note{
A user is not expected to need this function. It is mainly
used by plotting functions, specially when clipping the plot in 
a zoomed region.
}
\examples{

kp <- plotKaryotype(plot.type=2)
dp1 <- getDataPanelBoundingBox(kp, 1)
 
}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpDataBackground}}
}
