% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCytobandColors.R
\name{getCytobandColors}
\alias{getCytobandColors}
\title{getCytobandColors}
\usage{
getCytobandColors(color.table=NULL, color.schema=c("circos", "biovizbase", "only.centromeres"))
}
\arguments{
\item{color.table}{(named character vector) if present, it's returned as-is. Useful to specify your own color.tables.}

\item{color.schema}{(character) The name of the color schema to use: \code{circos}, \code{biovizBase}, \code{only.centromeres} (everything in gray, except for centromeres in red). (defaults to \code{circos})}
}
\value{
a named character vector with the colors associated to each cytoband name
}
\description{
Returns a named character vector with the colors of associated with the cytoband names
}
\details{
The function returns a named character vector with the colors of associated with the 
cytoband names. Two color schemas are available: circos (which copies the colors used by 
Circos) and biovizbase (that gets the cytoband colors from the biovizBase Bioconductor 
package). If a color.table is given, it is returned untouched.
}
\examples{
 
getCytobandColors()
getCytobandColors(color.schema="biovizbase")
 
}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpAddCytobands}}
}
