% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{autotrack}
\alias{autotrack}
\title{autotrack}
\usage{
autotrack(current.track, total.tracks, margin=0.05, r0=0, r1=1)
}
\arguments{
\item{current.track}{(numeric) The track or tracks the current plot will occupy, starting from 1. If more than one value is provided, the plot will expand from min(current.track) to max(current.track).}

\item{total.tracks}{(numeric) The total number of tracks}

\item{margin}{(numeric) The margin is specified as the part of a track, by default 0.05, 5 percent of the track height.}

\item{r0}{(numeric) the original r0}

\item{r1}{(numeric) the original r1}
}
\value{
A list of two numerics: r0 and r1
}
\description{
Computes r0 and r1 given track definition
}
\details{
Small utility function to help compute r0 and r1 given the total number of tracks 
and the track(s) the current plot will occupy. It also takes into account a margin
between tracks and original r0 and r1, so we can say something like, "Out of 5 
tracks between 0 and 0.5, this plot will be at track 2", and it will return
r0=0.1 and r1=0.2
}
\examples{

#first track out of 4  
autotrack(1, 4)

#the same, but without margin
autotrack(1, 4, 0)

#first and second tracks out of 4
autotrack(c(1,2), 4)

#The first track out of 4, fitting the four track between 0 and 0.5
autotrack(1, 4, r0=0, r1=0.5)
 
}
