% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infercnv_sampling.R
\name{sample_object}
\alias{sample_object}
\title{sample_object}
\usage{
sample_object(
  infercnv_obj,
  n_cells = 100,
  every_n = NULL,
  above_m = NULL,
  on_references = TRUE,
  on_observations = TRUE
)
}
\arguments{
\item{infercnv_obj}{infercnv_object}

\item{n_cells}{Number of cells that should be sampled per group (default = 100).}

\item{every_n}{Sample 1 cell every_n cells for each group. If subclusters are defined, 
this will make sure that at least one cell per subcluster is sampled. 
Requires above_m to be set to work, overriding n_cells parameter.}

\item{above_m}{Sample groups that have at least above_m cells. 
Requires every_n to be set to work, overriding n_cells parameter}

\item{on_references}{boolean (default=TRUE), sample references (normal cells).}

\item{on_observations}{boolean (default=TRUE), sample observations data (tumor cells).}
}
\value{
sampled infercnv_obj
}
\description{
Apply sampling on an infercnv object to reduce the number of cells in it 
and allow faster plotting or have all groups take up the same height on the heatmap
}
\examples{
# data(infercnv_data_example)
# data(infercnv_annots_example)
# data(infercnv_genes_example)

# infercnv_object_example <- infercnv::CreateInfercnvObject(raw_counts_matrix=infercnv_data_example, 
#                                                           gene_order_file=infercnv_genes_example,
#                                                           annotations_file=infercnv_annots_example,
#                                                           ref_group_names=c("normal"))

# infercnv_object_example <- infercnv::run(infercnv_object_example,
#                                          cutoff=1,
#                                          out_dir=tempfile(), 
#                                          cluster_by_groups=TRUE, 
#                                          denoise=TRUE,
#                                          HMM=FALSE,
#                                          num_threads=2,
#                                          no_plot=TRUE)

data(infercnv_object_example)

infercnv_object_example <- infercnv::sample_object(infercnv_object_example, n_cells=5)
# plot result object

}
