% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inferCNV.R
\docType{class}
\name{infercnv-class}
\alias{infercnv-class}
\alias{infercnv}
\title{The infercnv Class}
\description{
An infercnv object encapsulates the expression data and gene chromosome ordering information
that is leveraged by infercnv for data exploration.  The infercnv object is passed among the
infercnv data processing and plotting routines.
}
\details{
Slots in the infercnv object include:
}
\section{Slots}{

\describe{
\item{\code{expr.data}}{<matrix>  the count or expression data matrix, manipulated throughout infercnv ops}

\item{\code{count.data}}{<matrix>  retains the original count data, but shrinks along with expr.data when genes are removed.}

\item{\code{gene_order}}{<data.frame> chromosomal gene order}

\item{\code{reference_grouped_cell_indices}}{<list>  mapping [['group_name']] to c(cell column indices) for reference (normal) cells}

\item{\code{observation_grouped_cell_indices}}{<list> mapping [['group_name']] to c(cell column indices) for observation (tumor) cells}

\item{\code{tumor_subclusters}}{<list> stores subclustering of tumors if requested}

\item{\code{options}}{<list> stores the options relevant to the analysis in itself (in contrast with options relevant to plotting or paths)}

\item{\code{.hspike}}{a hidden infercnv object populated with simulated spiked-in data}
}}

