% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainIMGT.R
\name{refreshIMGT}
\alias{refreshIMGT}
\title{Force Re-download of IMGT/HLA Sequences}
\usage{
refreshIMGT(
  species = "human",
  gene,
  type = c("NUC", "PROT"),
  suppressMessages = FALSE
)
}
\arguments{
\item{species}{The species for which to download data. Required for TCR/BCR queries.
Currently supported: "human", "mouse", "rat", "rabbit", "pig", "dog", "rhesus_monkey", "cyno monkey". Defaults to "human" for HLA.}

\item{gene}{The gene or locus to download. For TCR/BCR, this can be a specific
chain (e.g., "IGHV", "TRBJ") or a group (e.g., "IGH", "TCR"). For HLA, use "HLA".}

\item{type}{The type of sequence to retrieve. Either "NUC" for nucleotide or
"PROT" for protein sequences. This primarily distinguishes between VDJ nucleotide
and V-region amino acid sequences for TCR/BCR genes.}

\item{suppressMessages}{Logical. If `TRUE`, suppresses the license and other
informational messages.}
}
\value{
A `DNAStringSet` or `AAStringSet` object.
}
\description{
A convenience wrapper for `getIMGT(..., refresh = TRUE)` to ensure that
the local cache is updated with the latest versions of the requested sequences.
}
\examples{
if(is_imgt_available()) {
  # Force a re-download of human IGHV protein sequences
  ighv_prot_fresh <- refreshIMGT(species = "human", gene = "IGHV", type = "PROT")
}
}
