% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igvShiny.R
\name{showGenomicRegion}
\alias{showGenomicRegion}
\alias{getGenomicRegion}
\title{focus igv on a region}
\usage{
showGenomicRegion(session, id, region)

getGenomicRegion(session, id)
}
\arguments{
\item{session}{an environment or list, provided and managed by shiny}

\item{id}{character string, the html element id of this widget instance}

\item{region}{a character string, either e.g. "chr5:92,221,640-92,236,523" 
or "MEF2C"}
}
\value{
a character string of format "chrom:start-end"
}
\description{
zoom in or out to show the nominated region, by chromosome locus
or gene symbol

return the current region displayed by your igv instance
}
\examples{
library(igvShiny)
demo_app_file <-
  system.file(package = "igvShiny", "demos", "igvShinyDemo.R")
if (interactive()) {
  shiny::runApp(demo_app_file)
}

library(igvShiny)
demo_app_file <-
  system.file(package = "igvShiny", "demos", "igvShinyDemo.R")
if (interactive()) {
  shiny::runApp(demo_app_file)
}

}
\keyword{igvShiny}
