% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igvShiny.R
\name{loadBamTrackFromLocalData}
\alias{loadBamTrackFromLocalData}
\title{load GenomicAlignments data as an igv.js alignment track}
\usage{
loadBamTrackFromLocalData(
  session,
  id,
  trackName,
  data,
  deleteTracksOfSameName = TRUE,
  displayMode = "EXPANDED"
)
}
\arguments{
\item{session}{an environment or list, provided and managed by shiny}

\item{id}{character string, the html element id of this widget instance}

\item{trackName}{character string}

\item{data}{GenomicAlignments object}

\item{deleteTracksOfSameName}{logical, default TRUE}

\item{displayMode}{character string, possible values are "EXPANDED"(default),
"SQUISHED" or "COLLAPSED"}
}
\value{
nothing
}
\description{
load GenomicAlignments data  as an igv.js alignment track
}
\examples{
library(igvShiny)
demo_app_file <-
  system.file(package = "igvShiny", "demos", "igvShinyDemo.R")
if (interactive()) {
  shiny::runApp(demo_app_file)
}

}
\keyword{track_loaders}
