% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hic.R
\name{parse_juicer_matrix}
\alias{parse_juicer_matrix}
\title{Parse .hic files from Juicer for IDR2D analysis}
\usage{
parse_juicer_matrix(
  hic_file,
  resolution = 1e+06,
  normalization = c("NONE", "VC", "VC_SQRT", "KR"),
  chromosome = "chr1",
  use_python = NULL,
  use_virtualenv = NULL,
  use_condaenv = NULL
)
}
\arguments{
\item{hic_file}{path to .hic file (either local file path or URL).}

\item{resolution}{block resolution of Hi-C contact matrix in base pairs,
defaults to 1,000,000 bp (usually one of the following:
2500000, 1000000, 500000, 250000, 100000, 50000, 25000, 10000, 5000)}

\item{normalization}{normalization step performed by Python package
\code{hic-straw}, one of the following: \code{"NONE"}, \code{"VC"},
\code{"VC_SQRT"}, \code{"KR"}.}

\item{chromosome}{chromsome name to be analyzed,
defaults to UCSC chromosome 1 (\code{"chr1"})}

\item{use_python}{if Python is not on PATH, specify path to Python binary
here (see \code{\link[reticulate:use_python]{use_python}})}

\item{use_virtualenv}{if Python package \code{hic-straw} is not in base
virtualenv environment, specify environment here (see
\code{\link[reticulate:use_python]{use_virtualenv}})}

\item{use_condaenv}{if Python package \code{hic-straw} is not in base
conda environment, specify environment here (see
\code{\link[reticulate:use_python]{use_condaenv}})}
}
\value{
Data frame with the following columns:
\tabular{rll}{
  column 1: \tab \code{chr} \tab character; chromosome of block
  (e.g., \code{"chr3"})\cr
  column 2: \tab \code{region1} \tab integer; genomic location of side A of
  block in Hi-C contact matrix\cr
  column 3: \tab \code{region2} \tab integer; genomic location of side B of
  block in Hi-C contact matrix\cr
  column 4: \tab \code{value} \tab numeric; (normalized) read count in block
}
}
\description{
\code{parse_juicer_matrix} uses the Python package \code{hic-straw}
internally to read .hic contact matrix files (see
\href{https://pypi.org/project/hic-straw/}{hic-straw on PyPI} or the
\href{https://pypi.org/project/hic-straw/}{Aiden lab GitHub repository}
for more information).

The contact matrix is subdivided into blocks, where the block size is
determined by \code{resolution}. The reads per block are used to rank blocks
and replicate blocks are easily matched by genomic location.
}
\references{
Neva C. Durand, James T. Robinson, Muhammad S. Shamim, Ido Machol, Jill
P. Mesirov, Eric S. Lander, and Erez Lieberman Aiden. "Juicebox provides
a visualization system for Hi-C contact maps with unlimited zoom."
Cell Systems 3(1), 2016.
}
