% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{establish_bijection}
\alias{establish_bijection}
\title{Finds One-to-One Correspondence between Peaks or interactions
from Replicate 1 and 2}
\usage{
establish_bijection(
  rep1_df,
  rep2_df,
  analysis_type = c("IDR1D", "IDR2D"),
  ambiguity_resolution_method = c("overlap", "midpoint", "value"),
  max_gap = -1L
)
}
\arguments{
\item{rep1_df}{data frame of observations (i.e., genomic peaks or genomic
interactions) of
replicate 1. If \code{analysis_type} is IDR1D, the columns of \code{rep1_df}
are described in \code{\link{establish_bijection1d}}, otherwise in
\code{\link{establish_bijection2d}}}

\item{rep2_df}{data frame of observations (i.e., genomic peaks or genomic
interactions) of replicate 2. Same columns as \code{rep1_df}.}

\item{analysis_type}{"IDR2D" for genomic interaction data sets,
"IDR1D" for genomic peak data sets}

\item{ambiguity_resolution_method}{defines how ambiguous assignments
(when one interaction or peak in replicate 1 overlaps with
multiple interactions or peaks in replicate 2 or vice versa)
are resolved. For available methods, see \code{\link{establish_overlap1d}} or
\code{\link{establish_overlap2d}}, respectively.}

\item{max_gap}{integer; maximum gap in nucleotides allowed between two
anchors for them to be considered as overlapping
(defaults to -1, i.e., overlapping anchors)}
}
\value{
See \code{\link{establish_bijection1d}} or
\code{\link{establish_bijection2d}}, respectively.
}
\description{
This method establishes a bijective assignment between observations
(genomic peaks in case of ChIP-seq, genomic interactions in case of
ChIA-PET, HiChIP, and Hi-C) from
replicate 1 and 2. An observation in replicate 1 is assigned to an
observation in replicate 2 if and only if (1) the observation loci in both
replicates overlap (or the gap between them is less than
or equal to \code{max_gap}), and (2) there is no other observation in
replicate 2 that overlaps with the observation in replicate 1 and has a
lower \emph{ambiguity resolution value}.
}
\examples{
rep1_df <- idr2d:::chipseq$rep1_df
rep1_df$value <- preprocess(rep1_df$value, "log")

rep2_df <- idr2d:::chipseq$rep2_df
rep2_df$value <- preprocess(rep2_df$value, "log")

mapping <- establish_bijection(rep1_df, rep2_df, analysis_type = "IDR1D")

}
