% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{determine_anchor_overlap}
\alias{determine_anchor_overlap}
\title{Identifies Overlapping Anchors}
\usage{
determine_anchor_overlap(rep1_anchor, rep2_anchor, max_gap = -1L)
}
\arguments{
\item{rep1_anchor}{data frame with the following columns:
\tabular{rll}{
  column 1: \tab \code{chr} \tab character; genomic location of anchor in
  replicate 1 - chromosome (e.g., \code{"chr3"})\cr
  column 2: \tab \code{start} \tab integer; genomic location of anchor in
  replicate 1 - start coordinate\cr
  column 3: \tab \code{end} \tab integer; genomic location of anchor in
  replicate 1 - end coordinate
}}

\item{rep2_anchor}{data frame with the following columns:
\tabular{rll}{
  column 1: \tab \code{chr} \tab character; genomic location of anchor in
  replicate 2 - chromosome (e.g., \code{"chr3"})\cr
  column 2: \tab \code{start} \tab integer; genomic location of anchor in
  replicate 2 - start coordinate\cr
  column 3: \tab \code{end} \tab integer; genomic location of anchor in
  replicate 2 - end coordinate
}}

\item{max_gap}{integer; maximum gap in nucleotides allowed between two
anchors for them to be considered as overlapping
(defaults to -1, i.e., overlapping anchors)}
}
\value{
A data frame containing overlapping
 anchor pairs with the following columns:
\tabular{rll}{
  column 1: \tab \code{rep1_idx} \tab anchor index in data frame
  \code{rep1_anchor} \cr
  column 2: \tab \code{rep2_idx} \tab anchor index in data frame
  \code{rep2_anchor}
}
}
\description{
Identifies all overlapping anchor pairs (m:n mapping).
}
\examples{
rep1_df <- idr2d:::chiapet$rep1_df
rep2_df <- idr2d:::chiapet$rep2_df

rep1_anchor_a <- data.frame(chr = rep1_df[, 1],
                            start = rep1_df[, 2],
                            end = rep1_df[, 3])
rep2_anchor_a <- data.frame(chr = rep2_df[, 1],
                            start = rep2_df[, 2],
                            end = rep2_df[, 3])

anchor_a_overlap <- determine_anchor_overlap(rep1_anchor_a, rep2_anchor_a)


}
