% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structuralTendency.R
\name{structuralTendency}
\alias{structuralTendency}
\title{Structural Tendency of Amino Acid Residues}
\usage{
structuralTendency(
  sequence,
  disorderPromoting = c("P", "E", "S", "Q", "K", "A", "G"),
  disorderNeutral = c("D", "T", "R"),
  orderPromoting = c("M", "N", "V", "H", "L", "F", "Y", "I", "W", "C"),
  printCitation = FALSE
)
}
\arguments{
\item{sequence}{amino acid sequence as a single character string,
a vector of single characters, or an AAString object.
It also supports a single character string that specifies
the path to a .fasta or .fa file.}

\item{disorderPromoting, disorderNeutral, orderPromoting}{character vectors
of individual residues to be matched with the input sequence. Defaults:
\itemize{
  \item disorderPromoting = c("P", "E", "S", "Q", "K", "A", "G")
  \item orderPromoting =
     c("M", "N", "V", "H", "L", "F", "Y", "I", "W", "C")
  \item disorderNeutral = c("D", "T", "R")
}
It is not recommended to change these. These definitions are from
Uversky (2013).}

\item{printCitation}{logical, FALSE by default.
When \code{printCitation = TRUE}, a citation to Uversky, V. N. (2013)
is printed. This is the paper categorizing the structural impact of each
residue that is used as the default settings.}
}
\value{
a data frame containing each residue from the sequence
  matched with its structural tendency, defined by disorderPromoting,
  disorderNeutral, and orderPromoting.
  For convenient plotting see \code{\link{structuralTendencyPlot}}.
}
\description{
Each amino acid residue has a tendency to impact the order / disorder
  of the amino acid sequence. Some residues are disorder promoting, meaning
  they tend to favor disorder over ordered structures. These are typically
  hydrophilic, charged, or small residues. Order promoting residues tend
  to be aliphatic, hydrophobic, aromatic, or form tertiary structures.
  Disorder neutral residues neither favor order nor disordered structures.
}
\examples{
#Amino acid sequences can be character strings
aaString <- "ACDEFGHIKLMNPQRSTVWY"
#Amino acid sequences can also be character vectors
aaVector <- c("A", "C", "D", "E", "F",
              "G", "H", "I", "K", "L",
              "M", "N", "P", "Q", "R",
             "S", "T", "V", "W", "Y")
#Alternatively, .fasta files can also be used by providing
##The path to the file as a character string

exampleDF <- structuralTendency(aaString)
head(exampleDF)
exampleDF <- structuralTendency(aaVector)
head(exampleDF)

#This example shows if a user changes the default definition of residues.
##These residues are labeled as such from Dunker et al (2001),
##"Intrinsically disordered protein."
exampleDF <- structuralTendency(aaString,
               disorderPromoting = c("A", "R", "G", "Q", "S", "P", "E", "K"),
               disorderNeutral = c("H", "M", "T", "D"),
               orderPromoting = c("W", "C", "F", "I", "Y", "V", "L", "N"))
head(exampleDF)
}
\references{
Uversky, V. N. (2013). A decade and a half of protein intrinsic disorder:
  Biology still waits for physics. Protein Science, 22(6), 693-724.
  \url{https://doi.org/10.1002/pro.2261}. \cr
  Kulkarni, Prakash, and Vladimir N. Uversky. "Intrinsically
  disordered proteins: the dark horse of the dark proteome."
  Proteomics 18.21-22 (2018): 1800061.
  \url{https://doi.org/10.1002/pmic.201800061}.
}
\seealso{
Other structural tendency: 
\code{\link{structuralTendencyPlot}()}
}
\concept{structural tendency}
