% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequencePlot.R
\name{sequencePlot}
\alias{sequencePlot}
\title{Sequence Plot}
\usage{
sequencePlot(
  position,
  property,
  hline = NA,
  propertyLimits = NA,
  dynamicColor = NA,
  customColors = NA,
  midpoint = hline,
  customTitle = NA
)
}
\arguments{
\item{position}{numeric vector of residue positions.
Typically c(1 : sequenceLength). ie a sequence with 215 amino acids
has a vector of values 1 to 215. This is the X axis}

\item{property}{vector of values, typically numeric. Equal in length
to position. This is the Y axis.}

\item{hline, propertyLimits}{optional, numeric values or numeric vectors.
Prints horizontal lines. Set to NA to skip (default).
 *hline* specifies the location for a dashed,
grey line to be printed underneath the plot's data line.
Good for separating cutoff values. *propertyLimits* specifies the location
for a solid, black line to be printed. Good for showing maximum and
minimum values.}

\item{dynamicColor}{optional vector. Typically numeric. Equal in length
to position. Can be used to set colors based on values. Can be
categorical (discrete) or continuous. Set to NA to skip (default).}

\item{customColors}{optional vector of colors as character strings.
Used to support custom plot colors. If property is a discrete scale, a
character vector of colors with length = number of unique discrete
observations is required. If property is a continuous scale, a character
vector of the colors for c("highColor","lowColor","midColor").
Set NA to skip custom colors (default). Ignored if
\code{dynamicColor = NA}.}

\item{midpoint}{needed for proper scales of customColors. The default
value is equal to hline (if provided). If there is no hline, the average
of propertyLimits is the midpoint (if provided). If neither is provided,
the value will be NA. The user can explicitly assign the midpoint to
avoid this or to overwrite the defaults.}

\item{customTitle}{optional, character string. Allows adding custom title.
Set to NA to skip (default).}
}
\value{
a ggplot
}
\description{
This is a graphical function used to visualize numeric
  data along an amino acid sequence.
}
\examples{
#Get a data frame returned from another function
aaVector <- c("A", "C", "D", "E", "F",
           "G", "H", "I", "K", "L",
           "M", "N", "P", "Q", "R",
           "S", "T", "V", "W", "Y")
exampleDF <- chargeCalculationGlobal(sequence = aaVector)
head(exampleDF)
#Making a sequence plot
sequencePlot(
  position = exampleDF$Position,
  property = exampleDF$Charge)

#Change the horizontal lines
sequencePlot(
position = exampleDF$Position,
property = exampleDF$Charge,
hline = 0.0,
propertyLimits = c(-1.0, 1.0))

#Adding a dynamic colors based on the property values
sequencePlot(
position = exampleDF$Position,
  property = exampleDF$Charge,
hline = 0.0,
propertyLimits = c(-1.0, 1.0),
dynamicColor = exampleDF$Charge,
customColors = c("red", "blue", "grey50"),
customTitle = "Charge of Each Residue / Terminus")
}
