% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeGating.R
\name{modeGating}
\alias{modeGating}
\title{App pre-configured to link multiple feature assay plots}
\usage{
modeGating(se, features, plotAssay = NA_character_, ..., plotWidth = 4)
}
\arguments{
\item{se}{An object that coercible to
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment-class}}

\item{features}{\code{data.frame} with columns named \code{x} and \code{y}
that define the features on the axes of the linked plots.
Plots are serially linked from the first row to the last.}

\item{plotAssay}{The assay (one of assayNames(se)) to use for the plots
(character vector of length either 1 or equal to \code{nrow(features)}).}

\item{...}{Additional arguments passed to \code{\link[=iSEE]{iSEE()}}.}

\item{plotWidth}{The grid width of linked plots (numeric vector of
length either 1 or equal to \code{nrow(features)}}
}
\value{
A Shiny app object is returned.
}
\description{
This mode launches a Shiny App preconfigured with multiple chain-linked
feature expression plots for interactive data exploration of the
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment} or
\code{\link{SummarizedExperiment}} object.
}
\examples{
library(scRNAseq)

# Example data ----
sce <- ReprocessedAllenData(assays="tophat_counts")
class(sce)

library(scater)
sce <- logNormCounts(sce, exprs_values="tophat_counts")

# Select top variable genes ----

plot_count <- 6
rv <- rowVars(assay(sce, "tophat_counts"))
top_var <- head(order(rv, decreasing=TRUE), plot_count*2)
top_var_genes <- rownames(sce)[top_var]

plot_features <- data.frame(
    x=head(top_var_genes, plot_count),
    y=tail(top_var_genes, plot_count),
    stringsAsFactors=FALSE
 )

# launch the app itself ----

app <- modeGating(sce, features = plot_features)
if (interactive()) {
  shiny::runApp(app, port=1234)
}

}
