% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VolcanoPlot.R
\docType{methods}
\name{VolcanoPlot-class}
\alias{VolcanoPlot-class}
\alias{VolcanoPlot}
\alias{initialize,VolcanoPlot-method}
\alias{.cacheCommonInfo,VolcanoPlot-method}
\alias{.refineParameters,VolcanoPlot-method}
\alias{.defineDataInterface,VolcanoPlot-method}
\alias{.createObservers,VolcanoPlot-method}
\alias{.hideInterface,VolcanoPlot-method}
\alias{.fullName,VolcanoPlot-method}
\alias{.panelColor,VolcanoPlot-method}
\alias{.generateDotPlotData,VolcanoPlot-method}
\alias{.allowableXAxisChoices,VolcanoPlot-method}
\alias{.allowableYAxisChoices,VolcanoPlot-method}
\alias{.prioritizeDotPlotData,VolcanoPlot-method}
\alias{.colorByNoneDotPlotField,VolcanoPlot-method}
\alias{.colorByNoneDotPlotScale,VolcanoPlot-method}
\alias{.generateDotPlot,VolcanoPlot-method}
\alias{.definePanelTour,VolcanoPlot-method}
\alias{.getDotPlotColorHelp,VolcanoPlot-method}
\title{The VolcanoPlot class}
\description{
The VolcanoPlot is a \linkS4class{RowDataPlot} subclass that is dedicated to creating a volcano plot.
It retrieves the log-fold change and p-value from and creates a row-based plot where each point represents a feature.
}
\section{Slot overview}{

The following slots control the thresholds used in the visualization:
\itemize{
\item \code{PValueThreshold}, a numeric scalar in (0, 1] specifying the threshold to use on the (adjusted) p-value.
Defaults to 0.05.
\item \code{LogFCThreshold}, a non-negative numeric scalar specifying the threshold to use on the log-fold change.
Defaults to 0.
\item \code{PValueCorrection}, a string specifying the multiple testing correction to apply.
Defaults to \code{"BH"}, but can take any value from \code{\link{p.adjust.methods}}.
}

In addition, this class inherits all slots from its parent \linkS4class{RowDataPlot},
\linkS4class{RowDotPlot}, \linkS4class{DotPlot} and \linkS4class{Panel} classes.
}

\section{Constructor}{

\code{VolcanoPlot(...)} creates an instance of a VolcanoPlot class,
where any slot and its value can be passed to \code{...} as a named argument.

Users are expected to load relevant statistics into the \code{\link{rowData}} of a \linkS4class{SummarizedExperiment}.
This panel expects one or more columns containing the p-values and log-fold changes for each gene/row - see Examples.
The expected column names (and how to tune them) are listed at \code{?"\link{registerPValueFields}"}.
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a \linkS4class{RowDataPlot} class.
Refer to the documentation for each method for more details on the remaining arguments.

For setting up data values:
\itemize{
\item \code{\link{.cacheCommonInfo}(x, se)} returns \code{se} after being loaded with class-specific constants.
This includes \code{"valid.p.fields"} and \code{"valid.lfc.fields"}, character vectors containing the names of valid \code{\link{rowData}} columns for the p-values and log-fold changes, respectively.
\item \code{\link{.refineParameters}(x, se)} returns \code{x} after setting \code{XAxis="Row data"} and the various \code{*Pattern} fields to their cached values.
This will also call the equivalent \linkS4class{RowDataPlot} method for further refinements to \code{x}.
If valid p-value and log-fold change fields are not available, \code{NULL} is returned instead.
}

For defining the interface:
\itemize{
\item \code{\link{.defineDataInterface}(x, se, select_info)} returns a list of interface elements for manipulating all slots described above.
\item \code{\link{.panelColor}(x)} will return the specified default color for this panel class.
\item \code{\link{.allowableXAxisChoices}(x, se)} returns a character vector specifying the acceptable log-fold change-related variables in \code{\link{rowData}(se)} that can be used as choices for the x-axis.
\item \code{\link{.allowableYAxisChoices}(x, se)} returns a character vector specifying the acceptable p-value-related variables in \code{\link{rowData}(se)} that can be used as choices for the y-axis.
\item \code{\link{.hideInterface}(x, field)} will return \code{TRUE} for \code{field="XAxis"},
otherwise it will call the \linkS4class{RowDataPlot} method.
\item \code{\link{.fullName}(x)} will return \code{"Volcano plot"}.
}

For monitoring reactive expressions:
\itemize{
\item \code{\link{.createObservers}(x, se, input, session, pObjects, rObjects)} sets up observers for all new slots described above, as well as in the parent classes via the \linkS4class{RowDataPlot} method.
}

For creating the plot:
\itemize{
\item \code{\link{.generateDotPlotData}(x, envir)} will create a data.frame of row metadata variables in \code{envir}.
This should contain negative log-transformed p-values on the y-axis and log-fold changes on the x-axis,
in addition to an extra field specifying whether or not the feature was considered to be significantly up or down.
The method will return the commands required to do so as well as a list of labels.
\item \code{\link{.prioritizeDotPlotData}(x, envir)} will create variables in \code{envir} marking the priority of points.
Significant features receive higher priority (i.e., are plotted over their non-significant counterparts) and are less aggressively downsampled when \code{Downsample=TRUE}.
The method will return the commands required to do this as well as a logical scalar indicating that rescaling of downsampling resolution is performed.
\item \code{\link{.colorByNoneDotPlotField}(x)} will return a string specifying the field of the data.frame (generated by \code{\link{.generateDotPlotData}}) containing the significance information.
This is to be used for coloring when \code{ColorBy="None"}.
\item \code{\link{.colorByNoneDotPlotScale}(x)} will return a string containing a \pkg{ggplot2} command to add a default color scale when \code{ColorBy="None"}.
\item \code{\link{.generateDotPlot}(x, labels, envir)} returns a list containing \code{plot} and \code{commands}, using the inital \linkS4class{ColumnDataPlot} \link{ggplot} and adding vertical lines demarcating the log-fold change threshold.
}

For documentation:
\itemize{
\item \code{\link{.definePanelTour}(x)} returns an data.frame containing the steps of a panel-specific tour.
\item \code{\link{.getDotPlotColorHelp}(x, color_choices)} returns a function that generates an \pkg{rintrojs} tour for the color choice UI.
}
}

\examples{
# Making up some results:
se <- SummarizedExperiment(matrix(rnorm(10000), 1000, 10))
rownames(se) <- paste0("GENE_", seq_len(nrow(se)))
rowData(se)$PValue <- runif(nrow(se))
rowData(se)$LogFC <- rnorm(nrow(se))
rowData(se)$AveExpr <- rnorm(nrow(se))

if (interactive()) {
    iSEE(se, initial=list(VolcanoPlot()))
}

}
\seealso{
\link{RowDataPlot}, for the base class.
}
\author{
Aaron Lun
}
