% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_text.R
\name{.addTourStep}
\alias{.addTourStep}
\title{Add a step to the tour}
\usage{
.addTourStep(x, field, text, is_selectize = FALSE)
}
\arguments{
\item{x}{A \linkS4class{Panel} object to be toured.}

\item{field}{String containing the name of the slot of \code{x}, itself corresponding to an interface element to highlight.}

\item{text}{String containing the text to show in the corresponding step of the tour.}

\item{is_selectize}{Logical scalar indicating whether \code{field} corresponds to a selectize element.}
}
\value{
Character vector of length two.
The first entry contains the \code{element} tag to identify the interface element to highlight,
while the second entry contains the \code{text}.

Alternatively, \code{NULL} may be returned if \code{\link{.hideInterface}(x, field)} indicates that the corresponding interface element has been hidden.
}
\description{
Utility to add a step to the panel-specific \pkg{rintrojs} tour, generating the \code{element} tag automatically.
}
\author{
Aaron Lun
}
