% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_tour.R
\name{specific-tours}
\alias{specific-tours}
\alias{.addSpecificTour}
\alias{.getSpecificTours}
\alias{.clearSpecificTours}
\title{UI-specific tour management utilities}
\usage{
.addSpecificTour(cls, field, fun, force = FALSE)

.getSpecificTours(cls)

.clearSpecificTours()
}
\arguments{
\item{cls}{String containing the name of the \linkS4class{Panel} class containing the relevant UI element.}

\item{field}{String containing the slot of the \code{cls} class that is controlled by the UI element.}

\item{fun}{Function that accepts a string containing the encoded Panel name,
and returns a data.frame compatible with \pkg{rintrojs}, i.e., with a \code{element} and \code{intro} column.}

\item{force}{Logical scalar indicating whether \code{fun} should forcibly overwrite an existing function in the tour cache for \code{cls} and \code{field}.}
}
\value{
\code{.addSpecificTour} registers the provided function in the tour cache for the provided \code{cls} and \code{field}.
A \code{NULL} is invisibly returned.

\code{.getSpecificTours} returns a list of registered tour-generating functions for the specified \code{cls}.

\code{.clearSpecificTours} removes all functions in the tour cache.
}
\description{
Utilities to manage the tours specific to individual UI elements for each \linkS4class{Panel}.
This is done via a global tour cache that is updated by each Panel's interface-generating methods,
so that developers can easily put the UI documentation next to the element definition.
}
\details{
By default, \code{.addSpecificTour} will have no effect if a function is already registered for a particular combination of \code{cls} and \code{field}.
However, users can force a replacement with \code{force=TRUE}.

\code{.clearSpecificTours} is intended for use by the \pkg{iSEE} app itself and should not be used by Panel methods.
}
\seealso{
\code{\link{.selectInput.iSEE}} and friends, which provide modified UI elements that can be clicked to launch a helpful tour.
}
\author{
Aaron Lun
}
