% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family_Table.R
\name{Table-class}
\alias{Table-class}
\alias{initialize,Table-method}
\alias{.refineParameters,Table-method}
\alias{.createObservers,Table-method}
\alias{.generateOutput,Table-method}
\alias{.renderOutput,Table-method}
\alias{.defineOutput,Table-method}
\alias{.exportOutput,Table-method}
\alias{.hideInterface,Table-method}
\alias{.multiSelectionCommands,Table-method}
\alias{.multiSelectionActive,Table-method}
\alias{.multiSelectionRestricted,Table-method}
\alias{.singleSelectionValue,Table-method}
\alias{.definePanelTour,Table-method}
\alias{.defineDataInterface,Table-method}
\alias{updateObject,Table-method}
\title{The Table class}
\description{
The Table is a virtual class for all panels containing a \code{\link{datatable}} widget from the \pkg{DT} package, where each row \emph{usually} corresponds to a row or column of the \linkS4class{SummarizedExperiment} object.
It provides observers for rendering the table widget, monitoring single selections, and applying global and column-specific searches (which serve as multiple selections).
}
\section{Slot overview}{

The following slots control aspects of the \code{DT::datatable} selection:
\itemize{
\item \code{Selected}, a string containing the name of the currently selected row of the data.frame.
Defaults to \code{NA}, in which case the value should be chosen by the subclass' \code{\link{.refineParameters}} method.
\item \code{Search}, a string containing the regular expression for the global search.
Defaults to \code{""}, i.e., no search.
\item \code{SearchColumns}, a unnamed character vector of length equal to the number of columns of the data.frame,
where each entry contains the search string for its corresponding column.
Alternatively, a character vector of variable length, containing search strings for one or more columns.
Defaults to an character vector of length zero, which is internally expanded to an vector of zero-length strings, i.e., no search.
}

The following slots control the appearance of the table:
\itemize{
\item \code{HiddenColumns}, a character vector containing names of columns to hide.
Defaults to an empty vector.
}

In addition, this class inherits all slots from its parent \linkS4class{Panel} class.
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a \linkS4class{Table} class.
Refer to the documentation for each method for more details on the remaining arguments.

For defining the interface:
\itemize{
\item \code{\link{.defineOutput}(x)} returns a UI element for a \code{\link[DT]{dataTableOutput}} widget.
\item \code{\link{.defineDataInterface}(x)} will create interface elements for modifying the table,
namely to choose which columns to hide.
Note that this is populated by \code{\link{.generateOutput}} upon table rendering,
as we do not know the available columns before that point.
}

For defining reactive expressions:
\itemize{
\item \code{\link{.createObservers}(x, se, input, session, pObjects, rObjects)} sets up observers for all of the slots.
This will also call the equivalent \linkS4class{Panel} method.
\item \code{\link{.renderOutput}(x, se, output, pObjects, rObjects)} will add a rendered \code{\link{datatable}} object to \code{output}.
This will also call the equivalent \linkS4class{Panel} method to render the panel information text boxes.
\item \code{\link{.generateOutput}(x, se, all_memory, all_contents)} returns a list containing \code{contents}, a data.frame with one row per point currently present in the table;
\code{commands}, a list of character vector containing the R commands required to generate \code{contents} and \code{plot};
and \code{varname}, a string specifying the name of the variable in \code{commands} used to generate \code{contents}.
\item \code{\link{.exportOutput}(x, se, all_memory, all_contents)} will create a CSV file containing the current table, and return a string containing the path to that file. 
This assumes that the \code{contents} field returned by \code{\link{.generateOutput}} is a data.frame or can be coerced into one.
}

For controlling selections:
\itemize{
\item \code{\link{.multiSelectionRestricted}(x)} returns \code{TRUE}.
Transmission of a selection to a Table will manifest as a subsetting of the rows.
\item \code{\link{.multiSelectionActive}(x)} returns a list containing the contents of \code{x[["Search"]]} and \code{x[["ColumnSearch"]]}.
If both contain only empty strings, a \code{NULL} is returned instead.
\item \code{\link{.multiSelectionCommands}(x, index)} returns a character vector of R expressions that - when evaluated - return a character vector of the row names of the table after applying all search filters.
The value of \code{index} is ignored.
\item \code{\link{.singleSelectionValue}(x, contents)} returns the name of the row that was last selected in the \code{\link{datatable}} widget.
}

For documentation:
\itemize{
\item \code{\link{.definePanelTour}(x)} returns an data.frame containing the steps of a tour relevant to subclasses,
mostly describing the effect of selection from other panels and the use of row filters to transmit selections.
}

Unless explicitly specialized above, all methods from the parent class \linkS4class{Panel} are also available.
}

\section{Subclass expectations}{

The Table is a rather vaguely defined class for which the only purpose is to avoid duplicating code for \linkS4class{ColumnDotPlot}s and \linkS4class{RowDotPlot}s.
We recommend extending those subclasses instead.
}

\seealso{
\linkS4class{Panel}, for the immediate parent class.
}
\author{
Aaron Lun
}
