% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_ColumnDataTable.R
\name{ColumnDataTable-class}
\alias{ColumnDataTable-class}
\alias{ColumnDataTable}
\alias{initialize,ColumnDataTable-method}
\alias{.cacheCommonInfo,ColumnDataTable-method}
\alias{.refineParameters,ColumnDataTable-method}
\alias{.generateTable,ColumnDataTable-method}
\alias{.panelColor,ColumnDataTable-method}
\alias{.fullName,ColumnDataTable-method}
\alias{.definePanelTour,ColumnDataTable-method}
\title{The ColumnDataTable panel}
\description{
The ColumnDataTable is a panel class for creating a \linkS4class{ColumnTable} where the value of the table is defined as the \code{\link{colData}} of the \linkS4class{SummarizedExperiment}.
It provides functionality to extract the \code{\link{colData}} to coerce it into an appropriate data.frame in preparation for rendering.
}
\section{Slot overview}{

This class inherits all slots from its parent \linkS4class{ColumnTable} and \linkS4class{Table} classes.
}

\section{Constructor}{

\code{ColumnDataTable(...)} creates an instance of a ColumnDataTable class, where any slot and its value can be passed to \code{...} as a named argument.

Note that \code{ColSearch} should be a character vector of length equal to the total number of columns in the \code{\link{colData}}, though only the entries for the atomic fields will actually be used.
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a \linkS4class{ColumnDataTable} class.
Refer to the documentation for each method for more details on the remaining arguments.

For setting up data values:
\itemize{
\item \code{\link{.cacheCommonInfo}(x)} adds a \code{"ColumnDataTable"} entry containing \code{valid.colData.names}, a character vector of names of atomic columns of the \code{\link{colData}}.
This will also call the equivalent \linkS4class{ColumnTable} method.
\item \code{\link{.refineParameters}(x, se)} adjusts \code{ColSearch} to a character vector of length equal to the number of atomic fields in the \code{\link{colData}}.
This will also call the equivalent \linkS4class{ColumnTable} method for further refinements to \code{x}.
}

For defining the interface:
\itemize{
\item \code{\link{.fullName}(x)} will return \code{"Column data table"}.
\item \code{\link{.panelColor}(x)} will return the specified default color for this panel class.
}

For creating the output:
\itemize{
\item \code{\link{.generateTable}(x, envir)} will modify \code{envir} to contain the relevant data.frame for display,
while returning a character vector of commands required to produce that data.frame.
Each row of the data.frame should correspond to a column of the SummarizedExperiment.
}

For documentation:
\itemize{
\item \code{\link{.definePanelTour}(x)} returns an data.frame containing the steps of a panel-specific tour.
}

Unless explicitly specialized above, all methods from the parent class \linkS4class{Panel} are also available.
}

\examples{
#################
# For end-users #
#################

x <- ColumnDataTable()
x[["Selected"]]
x[["Selected"]] <- "SOME_SAMPLE_NAME"

##################
# For developers #
##################

library(scater)
sce <- mockSCE()

# Search column refinement works as expected.
sce0 <- .cacheCommonInfo(x, sce)
.refineParameters(x, sce0)

}
\author{
Aaron Lun
}
