% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fctAssignmentGenesEnrichr.R
\name{fctAssignmentGenesEnrichr}
\alias{fctAssignmentGenesEnrichr}
\title{fctAssignmentGenesEnrichr}
\usage{
fctAssignmentGenesEnrichr(
  clusterAssignmentsProtGenes,
  database = "GO_Biological_Process_2023"
)
}
\arguments{
\item{clusterAssignmentsProtGenes}{(data frame containing cluster_assignments and HMDB/Symbol)}

\item{database}{A list with all the available databases from enrichr}
}
\value{
result_list data frame containing cluster_assignments and Enrichr terms
}
\description{
Enrichr terms for genes (Proteins and transcriptomics)
}
\examples{
if (interactive()) {
  # Simulated cluster assignments with gene symbols
  cluster_assignments <- data.frame(
    feature = c("F1", "F2", "F3", "F4"),
    cluster = c("cluster_1", "cluster_1", "cluster_2", "cluster_2"),
    col = c("#FF0000", "#FF0000", "#00FF00", "#00FF00"),
    feature_name = c("TP53", "BRCA1", "EGFR", "MYC"),
    stringsAsFactors = FALSE
  )

  # Run enrichment analysis using Enrichr (requires internet connection)
  enriched_results <- fctAssignmentGenesEnrichr(
    clusterAssignmentsProtGenes = cluster_assignments,
    database = "GO_Biological_Process_2023"
  )

  # View results
  head(enriched_results)
}

}
