% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R,
%   R/COBRAPlot.R
\docType{methods}
\name{fdrtpr}
\alias{fdrtpr}
\alias{fdrtpr<-}
\alias{fdrtpr,COBRAPerformance-method}
\alias{fdrtpr<-,COBRAPerformance,data.frame-method}
\alias{fdrtpr,COBRAPlot-method}
\alias{fdrtpr<-,COBRAPlot,data.frame-method}
\title{Accessor and replacement functions for \code{fdrtpr} slot}
\usage{
fdrtpr(x, ...)

fdrtpr(x, ...) <- value

\S4method{fdrtpr}{COBRAPerformance}(x)

\S4method{fdrtpr}{COBRAPerformance,data.frame}(x) <- value

\S4method{fdrtpr}{COBRAPlot,data.frame}(x) <- value
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object.}

\item{...}{Additional arguments.}

\item{value}{A data frame giving information about the observed FPR and TPR
for each method and each stratification level, at various adjusted p-value
thresholds.}
}
\value{
The accessor function returns a data frame giving information about
  the observed FPR and TPR for each method and each stratification level, at
  various adjusted p-value thresholds.
}
\description{
Accessor and replacement functions for the \code{fdrtpr} slot in a
\code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   aspects = "fdrtpr")
head(fdrtpr(cobraperf))
}
\author{
Charlotte Soneson
}
