% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\docType{methods}
\name{plotColocal}
\alias{plotColocal}
\alias{plotColocal,matrix-method}
\alias{plotColocal,SpatialExperiment-method}
\title{Plot heatmap for neighbourhood analysis}
\usage{
plotColocal(object, ...)

\S4method{plotColocal}{matrix}(object, hm_width = 5, hm_height = 5)

\S4method{plotColocal}{SpatialExperiment}(
  object,
  pm_cols,
  self_cor = TRUE,
  by_group = NULL,
  hm_width = 5,
  hm_height = 5,
  cluster_row = TRUE,
  cluster_col = TRUE,
  return_matrix = FALSE
)
}
\arguments{
\item{object}{A probability matrix or SpatialExperiment.}

\item{...}{Ignore parameter.}

\item{hm_width}{Integer. The width of heatmap.}

\item{hm_height}{Integer. The height of heatmap.}

\item{pm_cols}{The colnames of probability matrix. This is requires for
SpatialExperiment input. Assuming that the probability is stored in the colData.}

\item{self_cor}{Logical. By default is TRUE, inidicating running a correlation
between neighbourhoods to perform a simple co-localization analysis.
When this set to FALSE, it will plot the average probability of each
neighbourhood by group using the by_group parameter.}

\item{by_group}{Character. This is required when self_cor is set to FALSE.}

\item{cluster_row}{Logical. Cluster rows.}

\item{cluster_col}{Logical. Cluster columns.}

\item{return_matrix}{Logical. Export a numeric matrix .}
}
\value{
A ComplexHeatmap plot. When return_matrix is set to TRUE,
return a matrix Object.
}
\description{
Plot heatmap for neighbourhood analysis
}
\examples{

data("spe_test")

spe <- readHoodData(spe, anno_col = "celltypes")

fnc <- findNearCells(spe, k = 100)

pm <- scanHoods(fnc$distance)

pm2 <- mergeByGroup(pm, fnc$cells)

spe <- mergeHoodSpe(spe, pm2)

plotColocal(spe, pm_cols = colnames(pm2))

plotColocal(spe, pm_cols = colnames(pm2), self_cor = FALSE, by_group = "cell_annotation")

}
