% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hoodscanR-package.R
\docType{package}
\name{hoodscanR-package}
\alias{hoodscanR-package}
\alias{hoodscanR}
\title{Method to identify cellular spatial neighbourhood from single cell spatial
transcriptomics data.}
\description{
\code{hoodscanR} implements a novel method to scan for cell neighbourhood from
spatial transcriptomics data at single cell level, such as CosMx and MERFISH etc.
\code{hoodscanR} takes the cellular position and cell type annotations
as inputs, allowing cellular spatial neighbourhood analysis.
}
\details{
Key neighborhood analysis functions include  \code{\link{findNearCells}, 
\link{scanHoods}, \link{mergeByGroup}, \link{calcMetrics}, 
\link{clustByHood}}.

Key visualisation functions include
\code{\link{plotTissue}, \link{plotHoodMat}, \link{plotColocal},
\link{plotProbDist}}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/DavisLaboratory/hoodscanR}
  \item \url{https://davislaboratory.github.io/hoodscanR/}
  \item Report bugs at \url{https://github.com/DavisLaboratory/hoodscanR/issues}
}

}
\author{
Ning Liu \email{liu.n@wehi.edu.au}
}
\keyword{internal}
