% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_metrics.R
\name{calcMetrics}
\alias{calcMetrics}
\title{Calculate metrics for probability matrix}
\usage{
calcMetrics(spe, pm = NA, pm_cols = NA, val_names = c("entropy", "perplexity"))
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{pm}{Optional. The probability matrix.}

\item{pm_cols}{The colnames of probability matrix. This is requires for
SpatialExperiment input. Assuming that the probability is
stored in the colData.}

\item{val_names}{Character vector with length of 2. Column names
used to store calculated entropy and perplexity.}
}
\value{
A SpatialExperiment object. Calculated entropy and perplexity are
saved as columns in the colData of the SpatialExperiment object.
Entropy and perplexity are calculated based on information theory:

P(x) is the probability calculated from the scanHoods function.

Entropy H(x) = -P(x)log2(P(x))

Perplexity P(x) = 2^H(x)

By default, the calculated entropy and perplexity will be stored
in the colData of the input spe, with column name as entropy and
perplexity.
}
\description{
Calculate metrics for probability matrix
}
\examples{

data("spe_test")

spe <- readHoodData(spe, anno_col = "celltypes")

fnc <- findNearCells(spe, k = 100)

pm <- scanHoods(fnc$distance)

pm2 <- mergeByGroup(pm, fnc$cells)

spe <- mergeHoodSpe(spe, pm2)

spe <- calcMetrics(spe, pm_cols = colnames(pm2))

}
