% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top_genes.R
\docType{class}
\name{top_genes}
\alias{top_genes}
\alias{HermesDataTopGenes-class}
\alias{.HermesDataTopGenes}
\alias{HermesDataTopGenes}
\alias{autoplot,HermesDataTopGenes-method}
\title{Derivation of Top Genes}
\usage{
top_genes(
  object,
  assay_name = "counts",
  summary_fun = rowMeans,
  n_top = if (is.null(min_threshold)) 10L else NULL,
  min_threshold = NULL
)

\S4method{autoplot}{HermesDataTopGenes}(
  object,
  x_lab = "HGNC gene names",
  y_lab = paste0(object@summary_fun_name, "(", object@assay_name, ")"),
  title = "Top most expressed genes"
)
}
\arguments{
\item{object}{(\code{AnyHermedData})\cr input.}

\item{assay_name}{(\code{string})\cr name of the assay to use for the sorting of genes.}

\item{summary_fun}{(\code{function})\cr summary statistics function to apply across the samples in
the assay resulting in a numeric vector with one value per gene.}

\item{n_top}{(\code{count} or \code{NULL})\cr selection criteria based on number of entries.}

\item{min_threshold}{(\code{number} or \code{NULL} )\cr selection criteria based on a minimum
summary statistics threshold.}

\item{x_lab}{(\code{string})\cr x-axis label.}

\item{y_lab}{(\code{string})\cr y-axis label.}

\item{title}{(\code{string})\cr plot title.}
}
\value{
A \link{HermesDataTopGenes} object.
}
\description{
\code{top_genes()} creates a \code{\link{HermesDataTopGenes}} object, which extends \code{\link{data.frame}}. It
contains two columns:
\itemize{
\item \code{expression}: containing the statistic values calculated by \code{summary_fun} across columns.
\item \code{name}: the gene names.
}

The corresponding \code{autoplot()} method then visualizes the result as a barplot.
}
\details{
\itemize{
\item The data frame is sorted in descending order of \code{expression} and only the top
entries according to the selection criteria are included.
\item Note that exactly one of the arguments \code{n_top} and \code{min_threshold} must be
provided.
}
}
\section{Functions}{
\itemize{
\item \code{autoplot(HermesDataTopGenes)}: Creates a bar plot from a \link{HermesDataTopGenes} object,
where the y axis shows the expression statistics for each of the top genes
on the x-axis.

}}
\examples{
object <- hermes_data

# Default uses average of raw counts across samples to rank genes.
top_genes(object)

# Instead of showing top 10 genes, can also set a minimum threshold on average counts.
top_genes(object, n_top = NULL, min_threshold = 50000)

# We can also use the maximum of raw counts across samples, by specifying a different
# summary statistics function.
result <- top_genes(object, summary_fun = rowMax)

# Finally we can produce barplots based on the results.
autoplot(result, title = "My top genes")
autoplot(result, y_lab = "Counts", title = "My top genes")
}
