% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_cor_samplevar.R
\name{h_pca_var_rsquared}
\alias{h_pca_var_rsquared}
\title{Calculation of R2 between Sample Variable and Principal Components}
\usage{
h_pca_var_rsquared(pca, x)
}
\arguments{
\item{pca}{(\code{matrix})\cr principal components matrix generated by \code{\link[=calc_pca]{calc_pca()}}.}

\item{x}{(\code{vector})\cr values of one sample variable from a \code{\link{AnyHermesData}} object.}
}
\value{
A vector with R2 values for each principal component.
}
\description{
This helper function calculates R2 values between one sample variable from \code{\link{AnyHermesData}}
and all Principal Components (PCs) separately (one linear model is fit for each PC).
}
\details{
Note that in case there are estimation problems for any of the PCs, then \code{NA} will
be returned for those.
}
\examples{
object <- hermes_data \%>\%
  add_quality_flags() \%>\%
  filter() \%>\%
  normalize()

# Obtain the principal components.
pca <- calc_pca(object)$x

# Obtain the sample variable.
x <- colData(object)$AGE18

# Correlate them.
r2 <- h_pca_var_rsquared(pca, x)
}
