% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertthat.R, R/checkmate.R
\name{assertions}
\alias{assertions}
\alias{is_class}
\alias{is_hermes_data}
\alias{is_counts_vector}
\alias{is_list_with}
\alias{one_provided}
\alias{is_constant}
\title{Additional Assertions for \code{assert_that}}
\usage{
is_class(x, class2)

is_hermes_data(x)

is_counts_vector(x)

is_list_with(x, elements)

one_provided(one, two)

is_constant(x)
}
\arguments{
\item{x}{an object to check.}

\item{class2}{(\code{character} or class definition)\cr the class to which \code{x} could belong.}

\item{elements}{(\code{character})\cr names of elements which should be in the list \code{x}.}

\item{one}{first input.}

\item{two}{second input.}
}
\value{
Depending on the function prefix.
\itemize{
\item \code{assert_} functions return the object invisibly if successful, and otherwise
throw an error message.
\item \code{check_} functions return \code{TRUE} if successful, otherwise a string with the
error message.
\item \code{test_} functions just return \code{TRUE} or \code{FALSE}.
}
}
\description{
We provide additional assertion functions which can be used together with
\code{\link[assertthat:assert_that]{assertthat::assert_that()}}.

We provide additional assertion functions which can be used together with
the \code{checkmate} functions. These are described in individual help pages
linked below.
}
\section{Functions}{
\itemize{
\item \code{is_class()}: checks the class.

\item \code{is_hermes_data()}: checks whether \code{x} is an \code{\link{AnyHermesData}} object.

\item \code{is_counts_vector()}: checks for a vector of counts (positive integers).

\item \code{is_list_with()}: checks for a list containing elements.

\item \code{one_provided()}: checks that exactly one of the two inputs \code{one}, \code{two} is not \code{NULL}.

\item \code{is_constant()}: checks whether the vector \code{x} is constant (only supports \code{numeric}, \code{factor},
\code{character}, \code{logical}). \code{NA}s are removed first.

}}
\examples{
# Assert a general class.
a <- 5
is_class(a, "character")

# Assert a `AnyHermesData` object.
is_hermes_data(hermes_data)
is_hermes_data(42)

# Assert a counts vector.
a <- 5L
is_counts_vector(a)

# Assert a list containing certain elements.
b <- list(a = 5, b = 3)
is_list_with(b, c("a", "c"))
is_list_with(b, c("a", "b"))

# Assert that exactly one of two arguments is provided.
a <- 10
b <- 10
one_provided(a, b)
one_provided(a, NULL)

# Assert a constant vector.
is_constant(c(1, 2))
is_constant(c(NA, 1))
is_constant(c("a", "a"))
is_constant(factor(c("a", "a")))
}
\seealso{
\code{\link[=assert_proportion]{assert_proportion()}}
}
