% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HermesData-methods.R
\docType{data}
\name{annotation,AnyHermesData-method}
\alias{annotation,AnyHermesData-method}
\alias{annotation}
\alias{.row_data_annotation_cols}
\alias{annotation<-,AnyHermesData,DataFrame-method}
\title{Annotation Accessor and Setter}
\format{
The annotation column names are available in the exported
character vector \code{.row_data_annotation_cols}.
}
\usage{
\S4method{annotation}{AnyHermesData}(object, ...)

.row_data_annotation_cols

\S4method{annotation}{AnyHermesData,DataFrame}(object) <- value
}
\arguments{
\item{object}{(\code{AnyHermesData})\cr object to access the annotations from.}

\item{...}{not used.}

\item{value}{(\code{DataFrame})\cr what should the annotations be replaced with.}
}
\value{
The \code{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame}} with the gene annotations:
\itemize{
\item \code{symbol}
\item \code{desc}
\item \code{chromosome}
\item \code{size}
}
}
\description{
These methods access and set the gene annotations stored in a \code{\link{AnyHermesData}} object.
}
\note{
When trying to replace the required annotations with completely missing
values for any genes, a warning will be given and the corresponding gene
IDs will be saved in the attribute \code{annotation.missing.genes}. Note also
that additional annotations beyond the required ones may be supplied and
will be stored.
}
\examples{
object <- hermes_data
head(annotation(object))
}
\keyword{datasets}
