% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdxmsqc-utils.R
\name{replicateOutlier}
\alias{replicateOutlier}
\title{Correlation based checks}
\usage{
replicateOutlier(object, experiment, timepoints)
}
\arguments{
\item{object}{An object of class QFeatures.}

\item{experiment}{A character vector indicating the experimental conditions}

\item{timepoints}{A numeric vector indicating the experimental timepoints}
}
\value{
Returns A list of the same length as the number of experiments indicating
outlier from correlation analysis. Outliers are flagged if their deuterium
uptake is highly variable.
}
\description{
Correlation based checks
}
\examples{
data("BRD4df_full")
BRD4df_filtered <- isMissingAtRandom(object = BRD4df_full)
BRD4df_full_imputed <- impute(BRD4df_filtered, method = "zero", i = 1)
experiment <- c("wt", "iBET")
timepoints <- rep(c(0, 15, 60, 600, 3600, 14000), each = 3)
monoStat <- replicateOutlier(object = BRD4df_full_imputed,
experiment = experiment, 
timepoints = timepoints)
}
\author{
Oliver Crook
}
