% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdxmsqc-utils.R
\name{compatibleUptake}
\alias{compatibleUptake}
\title{Check whether deuterium uptakes are compatible with difference overlapping
sequences.}
\usage{
compatibleUptake(object, overlap = 5, experiment = NULL, timepoints = NULL)
}
\arguments{
\item{object}{An object of class \code{QFeatures}}

\item{overlap}{How much overlap is required to check consistentcy. Default
is sequences within 5 residues}

\item{experiment}{A character vector indicating the experimental conditions}

\item{timepoints}{A numeric vector indicating the experimental timepoints}
}
\description{
Check whether deuterium uptakes are compatible with difference overlapping
sequences.
}
\examples{
data("BRD4df")
result <- compatibleUptake(BRD4df,  experiment = 1, timepoints = 1)
}
\author{
Oliver Crook
}
