\name{mergeTallies}
\alias{mergeTallies}
\title{Merging the prepared results from multiple bam file tallies into one block that can be written to the HDF5 tally file}
\description{
This function merges a set of tallies that have been processed with \code{prepareForHDF5} into one block of data.
}
\usage{
mergeTallies( tallies )
}
\arguments{
  \item{tallies}{A list of prepared talies, i.e. a list of lists with slots for the datasets "Counts", "Coverage", "Deletions" and "Reference" in each sub-list}
}
\details{
This function merges tallies from a set of bam files / samples, note that the order of samples in the sample column will be the same as the order of samples in the provided list, so ake sure this matches your sampledata.
}
\value{
  A list with slots containing the \code{Counts},\code{Coverages},\code{Deletions} and \code{Reference} datasets for the samples given in \code{tallies}. Each of the slots contains an array with the contents of the provided sub-lists merged along the "sample" axis. The \code{Reference} slot os filled from the first element of \code{tallies} and it is up to the user to make sure that the tallies provided for merging have compatible references.
}
\author{
Paul Pyl
}
\examples{
library(h5vc)
library(BSgenome.Hsapiens.UCSC.hg19)
files <- c("NRAS.AML.bam","NRAS.Control.bam")
bamFiles <- file.path( system.file("extdata", package = "h5vcData"), files)
chrom = "1"
startpos <- 115247090
endpos <- 115259515
theData <- lapply( bamFiles, function(bamf){ tallyBAM(bamf, chrom, startpos, endpos) } )
str(theData)
reference <- getSeq(BSgenome.Hsapiens.UCSC.hg19, "chr1", startpos, endpos)
theMergedData <- mergeTallies(lapply(theData, prepareForHDF5, reference))
str(theMergedData)
}
