% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwcex2gviz.R
\name{gwcex2gviz}
\alias{gwcex2gviz}
\title{Prepare salient components of GWAS catalog for rendering with Gviz}
\usage{
gwcex2gviz(
  basegr,
  contextGR = GRanges(seqnames = "chr17", IRanges::IRanges(start = 37500000, width =
    1e+06)),
  txrefobj = TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene,
  genome = "hg19",
  genesymobj = org.Hs.eg.db::org.Hs.eg.db,
  plot.it = TRUE,
  maxmlp = 25
)
}
\arguments{
\item{basegr}{gwaswloc instance containing information about GWAS in catalog}

\item{contextGR}{A GRanges instance delimiting the visualization in genomic
coordinates}

\item{txrefobj}{a TxDb instance}

\item{genome}{character tag like 'hg19'}

\item{genesymobj}{an OrgDb instance}

\item{plot.it}{logical, if FALSE, just return list}

\item{maxmlp}{maximum value of -10 log p -- winsorization of all larger
values is performed, modifying the contents of Pvalue\_mlogp in the
elementMetadata for the call}
}
\description{
Prepare salient components of GWAS catalog for rendering with Gviz
}
\examples{

 data(ebicat_2020_04_30)
 # GenomeInfoDb::seqlevelsStyle(ebicat_2020_04_30) = "UCSC" # no more
 Seqinfo::seqlevels(ebicat_2020_04_30) = paste0("chr", Seqinfo::seqlevels(ebicat_2020_04_30))
 gwcex2gviz(ebicat_2020_04_30)

}
\keyword{graphics}
