% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sorenThreshold.R
\name{sorenThreshold}
\alias{sorenThreshold}
\alias{sorenThreshold.list}
\alias{sorenThreshold.tableList}
\title{For a given level (2, 3, ...) in a GO ontology (BP, MF or CC), compute the equivalence threshold
  dissimilarity matrix.}
\usage{
sorenThreshold(x, ...)

\method{sorenThreshold}{list}(
  x,
  onto,
  GOLevel,
  geneUniverse,
  orgPackg,
  boot = FALSE,
  nboot = 10000,
  boot.seed = 6551,
  trace = TRUE,
  alpha = 0.05,
  precis = 0.001,
  ...
)

\method{sorenThreshold}{tableList}(
  x,
  boot = FALSE,
  nboot = 10000,
  boot.seed = 6551,
  trace = TRUE,
  alpha = 0.05,
  precis = 0.001,
  ...
)
}
\arguments{
\item{x}{either an object of class "list" or class "tableList".
See the details section for more information.}

\item{...}{additional arguments to \code{buildEnrichTable}}

\item{onto}{character, GO ontology ("BP", "MF" or "CC") under consideration}

\item{GOLevel}{integer (2, 3, ...) level of a GO ontology where the GO profiles are built}

\item{geneUniverse}{character vector containing the universe of genes from where geneLists have been extracted. This vector must be extracted from the annotation package declared in \code{orgPackg}. For more details see \href{../doc/README.html}{README File}.}

\item{orgPackg}{A string with the name of the genomic annotation package corresponding to a specific species to be analyzed, which must be previously installed and activated. For more details see \href{../doc/README.html}{README File}.}

\item{boot}{boolean. If TRUE, the p-values are computed by means
of a bootstrap approach instead of the asymptotic normal approach. Defaults to FALSE.}

\item{nboot}{numeric, number of initially planned bootstrap replicates. Ignored if
\code{boot == FALSE}. Defaults to 10000}

\item{boot.seed}{starting random seed for all bootstrap iterations. Defaults to 6551.
see the details section}

\item{trace}{boolean, the full process must be traced? Defaults to TRUE}

\item{alpha}{simultaneous nominal significance level for the equivalence tests to be repeteadly performed,
defaults to 0.05}

\item{precis}{numerical precision in the iterative search of the equivalence threshold dissimilarities,
defaults to 0.001}
}
\value{
An object of class "dist", the equivalence threshold dissimilarity matrix based on the
Sorensen-Dice dissimilarity.
}
\description{
For a given level (2, 3, ...) in a GO ontology (BP, MF or CC), compute the equivalence threshold
  dissimilarity matrix.
}
\details{
If \code{x} is an object of class "list", each of its elements must be a "character" vector of gene
identifiers (e.g., ENTREZ). Then all pairwise threshold dissimilarities between these gene lists are obtained.

Class "tableList" corresponds to objects representing all mutual enrichment contingency tables
generated in a pairwise fashion:
Given gene lists l1, l2, ..., lk, an object of class "tableList" (typically constructed by a call to function
\code{\link{buildEnrichTable}}) is a list of lists of
contingency tables tij generated from each pair of gene lists i and j, with the
following structure:

$l2

$l2$l1$t21

$l3

$l3$l1$t31, $l3$l2$t32

...

$lk$l1$tk1, $lk$l2$tk2, ..., $lk$l(k-1)tk(k-1)

If \code{x} is an object of class "tableList", the threshold dissimilarity is obtained
over each one of these tables.

If \code{boot == TRUE}, all series of \code{nboot} bootstrap replicates start from the same random
seed, provided by the argument \code{boot.seed}, except if \code{boot == NULL}.

Do not confuse the resulting threshold dissimilarity matrix with the Sorensen-Dice dissimilarities
computed in each equivalence test.

The dimension of the resulting matrix may be less than the number of original gene lists being
compared, as the process may not converge for some pairs of gene lists.
}
\section{Methods (by class)}{
\itemize{
\item \code{sorenThreshold(list)}: S3 method for class "list"

\item \code{sorenThreshold(tableList)}: S3 method for class "tableList"

}}
\examples{
# Gene lists to be explored for enrichment:
data(allOncoGeneLists)

# Obtaining ENTREZ identifiers for the gene universe of humans:
library(org.Hs.eg.db)
humanEntrezIDs <- keys(org.Hs.eg.db, keytype = "ENTREZID")

# This example is quite time consuming:
# sorenThreshold(allOncoGeneLists,
#                geneUniverse = humanEntrezIDs, orgPackg = "org.Hs.eg.db")
# Much faster:
# Object \code{cont_all_BP4} of class "tableList" contains all the pairwise contingency
# tables of joint enrichment for the gene lists in \code{allOncoGeneLists}, for the BP
# GO ontology at level 4:
data("cont_all_BP4")
sorenThreshold(cont_all_BP4)

}
