% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate_2_groups_cox.R
\name{separate2GroupsCox}
\alias{separate2GroupsCox}
\title{Separate data in High and Low risk groups (based on Cox model)}
\usage{
separate2GroupsCox(
  chosenBetas,
  xdata,
  ydata,
  probs = c(0.5, 0.5),
  noPlot = FALSE,
  plotTitle = "SurvivalCurves",
  xlim = NULL,
  ylim = NULL,
  expandYZero = FALSE,
  legendOutside = FALSE,
  stopWhenOverlap = TRUE,
  ...,
  chosen.btas = deprecated(),
  no.plot = deprecated(),
  plot.title = deprecated(),
  expand.yzero = deprecated(),
  legend.outside = deprecated(),
  stop.when.overlap = deprecated()
)
}
\arguments{
\item{chosenBetas}{list of testing coefficients to calculate prognostic
indexes, for example \code{list(Age = some_vector)}.}

\item{xdata}{n x m matrix with n observations and m variables.}

\item{ydata}{Survival object.}

\item{probs}{How to separate high and low risk patients \verb{50\%-50\%} is the
default, but for top and bottom \verb{40\%} -> \code{c(.4,.6)}.}

\item{noPlot}{Only calculate p-value and do not generate survival curve
plot.}

\item{plotTitle}{Name of file if.}

\item{xlim}{Optional argument to limit the x-axis view.}

\item{ylim}{Optional argument to limit the y-axis view.}

\item{expandYZero}{expand to y = 0.}

\item{legendOutside}{If TRUE legend will be outside plot, otherwise inside.}

\item{stopWhenOverlap}{when probs vector allows for overlapping of samples
in both groups, then stop.}

\item{...}{additional parameters to survminer::ggsurvplot}

\item{chosen.btas}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{no.plot}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{plot.title}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{expand.yzero}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{legend.outside}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{stop.when.overlap}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Otherwise it will calculate with duplicate samples, i.e. simply adding them
to xdata and ydata (in a different group).}
}
\value{
object with logrank test and kaplan-meier survival plot

A list with plot, p-value and kaplan-meier object. The plot was drawn from
survminer::ggsurvplot with only the palette, data and fit arguments being
defined and keeping all other defaults that can be customized as additional
parameters to this function.
}
\description{
Draws multiple kaplan meyer survival curves (or just 1) and calculates
logrank test
}
\examples{
xdata <- survival::ovarian[, c("age", "resid.ds")]
ydata <- data.frame(
    time = survival::ovarian$futime,
    status = survival::ovarian$fustat
)
separate2GroupsCox(c(age = 1, 0), xdata, ydata)
separate2GroupsCox(c(age = 1, 0.5), xdata, ydata)
separate2GroupsCox(
    c(age = 1), c(1, 0, 1, 0, 1, 0),
    data.frame(time = runif(6), status = rbinom(6, 1, .5))
)
separate2GroupsCox(list(
    aa = c(age = 1, 0.5),
    bb = c(age = 0, 1.5)
), xdata, ydata)
}
\seealso{
\code{\link[survminer:ggsurvplot]{survminer::ggsurvplot()}}
}
