% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{.runCache}
\alias{.runCache}
\alias{.runCache,function-method}
\title{Run function and save cache}
\usage{
.runCache(
  fun,
  ...,
  seed = NULL,
  baseDir = NULL,
  cachePrefix = "generic_cache",
  cacheDigest = list(),
  showMessage = NULL,
  forceRecalc = FALSE,
  addToHash = NULL
)

\S4method{.runCache}{function}(
  fun,
  ...,
  seed = NULL,
  baseDir = NULL,
  cachePrefix = "generic_cache",
  cacheDigest = list(),
  showMessage = NULL,
  forceRecalc = FALSE,
  addToHash = NULL
)
}
\arguments{
\item{fun}{function call name}

\item{...}{parameters for function call}

\item{seed}{when function call is random, this allows to set seed beforehand}

\item{baseDir}{directory where data is stored}

\item{cachePrefix}{prefix for file name to be generated from
parameters (...)}

\item{cacheDigest}{cache of the digest for one or more of the parameters}

\item{showMessage}{show message that data is being retrieved from cache}

\item{forceRecalc}{force the recalculation of the values}

\item{addToHash}{something to add to the filename generation}
}
\value{
the result of fun(...)
}
\description{
This method saves the function that's being called
}
\section{Functions}{
\itemize{
\item \code{.runCache(`function`)}: accepts function as first argument and save cache

}}
\examples{
# [optional] save cache in a temporary directory
#
glmSparseNet:::.baseDir(tempdir())
glmSparseNet:::.runCache(c, 1, 2, 3, 4)
#
# next three should use the same cache
#  note, the middle call should be a little faster as digest is not
#  calculated
#   for the first argument
glmSparseNet:::.runCache(c, 1, 2, 3, 4)
glmSparseNet:::.runCache(c, a = 1, 2, c = 3, 4)
\donttest{
# Using a local folder
# glmSparseNet:::.runCache(c, 1, 2, 3, 4, baseDir = "runcache")
}
}
