% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_apis.R
\name{.biomartLoad}
\alias{.biomartLoad}
\title{Common call to biomaRt to avoid repetitive code}
\usage{
.biomartLoad(attributes, filters, values, useCache, verbose)
}
\arguments{
\item{attributes}{Attributes you want to retrieve. A possible list of
attributes can be retrieved using the function biomaRt::listAttributes.}

\item{filters}{Filters (one or more) that should be used in the query.
A possible list of filters can be retrieved using the function
biomaRt::listFilters.}

\item{values}{Values of the filter, e.g. vector of affy IDs. If multiple
filters are specified then the argument should be a list of vectors of
which the position of each vector corresponds to the position of the filters
in the filters argument}

\item{useCache}{Boolean indicating if biomaRt cache should be used}

\item{verbose}{When using biomaRt in webservice mode and setting verbose to
TRUE, the XML query to the webservice will be printed.}
}
\value{
data.frame with attributes as columns and values translated to them
}
\description{
Common call to biomaRt to avoid repetitive code
}
\examples{
glmSparseNet:::.biomartLoad(
    attributes = c("external_gene_name", "ensembl_gene_id"),
    filters = "external_gene_name",
    values = c("MOB1A", "RFLNB", "SPIC", "TP53"),
    useCache = TRUE,
    verbose = FALSE
)
}
\seealso{
geneNames

ensemblGeneNames

protein2EnsemblGeneNames

biomaRt::getBM()

biomaRt::useEnsembl()
}
