% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_msa.R
\name{geom_msa}
\alias{geom_msa}
\title{geom_msa}
\usage{
geom_msa(
  data,
  font = "helvetical",
  mapping = NULL,
  color = "Chemistry_AA",
  custom_color = NULL,
  char_width = 0.9,
  none_bg = FALSE,
  by_conservation = FALSE,
  position_highlight = NULL,
  seq_name = NULL,
  border = NULL,
  consensus_views = FALSE,
  use_dot = FALSE,
  disagreement = TRUE,
  ignore_gaps = FALSE,
  ref = NULL,
  position = "identity",
  show.legend = FALSE,
  dms = FALSE,
  position_color = FALSE,
  ...
)
}
\arguments{
\item{data}{sequence alignment with data frame, generated by tidy_msa().}

\item{font}{font families, possible values are 'helvetical', 'mono', 
and 'DroidSansMono', 'TimesNewRoman'. Defaults is 'helvetical'.}

\item{mapping}{aes mapping
If font = NULL, only plot the background tile.}

\item{color}{A Color scheme. One of 'Clustal', 'Chemistry_AA', 'Shapely_AA',
'Zappo_AA', 'Taylor_AA', 'LETTER','CN6',, 'Chemistry_NT', 'Shapely_NT', 
'Zappo_NT', 'Taylor_NT'. Defaults is 'Chemistry_AA'.}

\item{custom_color}{A data frame with two column called "names" and 
"color".Customize the color scheme.}

\item{char_width}{a numeric vector. Specifying the character width in 
the range of 0 to 1. Defaults is 0.9.}

\item{none_bg}{a logical value indicating whether background 
should be displayed. Defaults is FALSE.}

\item{by_conservation}{a logical value. The most conserved regions have
the brightest colors.}

\item{position_highlight}{A numeric vector of the position that
need to be highlighted.}

\item{seq_name}{a logical value indicating whether sequence names
should be displayed. Defaults is 'NULL' which indicates that the 
sequence name is displayed when 'font = null', but 'font = char' 
will not be displayed. If 'seq_name = TRUE' the sequence name will 
be displayed in any case. If 'seq_name = FALSE' the sequence name will not
 be displayed under any circumstances.}

\item{border}{a character string. The border color.}

\item{consensus_views}{a logical value that opening consensus views.}

\item{use_dot}{a logical value. Displays characters as dots instead of
fading their color in the consensus view.}

\item{disagreement}{a logical value. Displays characters that disagreement
to consensus(excludes ambiguous disagreements).}

\item{ignore_gaps}{a logical value. When selected TRUE, 
gaps in column are treated as if that row didn't exist.}

\item{ref}{a character string. Specifying the reference sequence
which should be one of input sequences when 'consensus_views' is TRUE.}

\item{position}{Position adjustment, either as a string, or
 the result of a call to a position adjustment function,
default is 'identity' meaning 'position_identity()'.}

\item{show.legend}{logical. Should this layer be included in the legends?}

\item{dms}{logical.}

\item{position_color}{logical.}

\item{...}{additional parameter}
}
\value{
A list
}
\description{
Multiple sequence alignment layer for ggplot2. 
It creates background tiles with/without sequence characters.
}
\examples{
library(ggplot2)
aln <- system.file("extdata", "sample.fasta", package = "ggmsa")
tidy_aln <- tidy_msa(aln, start = 150, end = 170)
ggplot() + geom_msa(data = tidy_aln, font = NULL) + coord_fixed()
}
\author{
Guangchuang Yu, Lang Zhou
seq_name' work
position_highlight' work
border' work
none_bg' work
}
