% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc.R
\name{geom_helix}
\alias{geom_helix}
\title{geom_helix}
\usage{
geom_helix(helix_data, color_by = "length", overlap = FALSE, ...)
}
\arguments{
\item{helix_data}{a data frame. The file of nucleltide secondary structure
and then read by readSSfile().}

\item{color_by}{generate colors for helices by various rules,
including integer counts and value ranges one of "length" and "value"}

\item{overlap}{Logicals. If TRUE, two structures data called predict 
and known must be given(eg:heilx_data = list(known = data1, 
                                             predicted = data2)), 
plots the predicted helices that are known on top,
predicted helices that are not known on the bottom, and finally plots 
unpredicted helices on top in black.}

\item{...}{additional parameter}
}
\value{
ggplot2 layers
}
\description{
The layer of helix plot
}
\examples{
RF03120 <- system.file("extdata/Rfam/RF03120_SS.txt", package="ggmsa")
RF03120_fas <- system.file("extdata/Rfam/RF03120.fasta", package="ggmsa")
SS <- readSSfile(RF03120, type = "Vienna")
ggmsa(RF03120_fas, font = NULL,border = NA, 
    color = "Chemistry_NT", seq_name = FALSE) +
geom_helix(SS)
}
\author{
Lang Zhou
}
