##'  Assigning colors to sequence alignment.
##'
##'
##' @param y sequence alignment with data frame, generated by tidy_msa().
##' @param color a Color scheme. One of 'Clustal', 'Chemistry_AA', 
##' 'Shapely_AA', 'Zappo_AA', 'Taylor_AA', 'LETTER', 'CN6', 'Chemistry_NT',
##'  'Shapely_NT', 'Zappo_NT', 'Taylor_NT'. Defaults is 'Chemistry_AA'.
##' @param custom_color A data frame with two column called "names" 
##' and "color".Customize the color scheme.
##' @noRd
color_scheme <- function(y, color = "Chemistry_AA", custom_color = NULL) {
    if (!is.null(custom_color)){
        #Elimination factor interference
        custom_color[["names"]] <- as.character(custom_color[["names"]]) 
        #Fuzzy matching the string "colors" or "colours"
        custom_color[["color"]] <- as.character(custom_color$col)
        row.names(custom_color) <- custom_color[["names"]]
        scheme_AA$custom_color <- 
            custom_color[row.names(scheme_AA), "color"] %>% as.character()
        y$color <- scheme_AA[y$character, "custom_color"]
    }else{
        if(grepl("NT", color)){
            y$color <- scheme_NT[y$character, color]
        } else{
            y$color <- scheme_AA[y$character, color]
        }
    }
    return(y)
}


