% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlay_functions.R
\name{output_overlay_image}
\alias{output_overlay_image}
\title{output_overlay_image}
\usage{
output_overlay_image(
  gg,
  with_legend = TRUE,
  use_cache = TRUE,
  high_res = FALSE,
  res = 72,
  out = NULL,
  directory = NULL,
  transparent_colors = c("#FFFFFF", "#BFBFFF", "#BFFFBF", "#7F7F7F", "#808080"),
  unlink = TRUE,
  with_legend_image = FALSE,
  legend_horiz = FALSE,
  legend_space = 100
)
}
\arguments{
\item{gg}{ggraph object}

\item{with_legend}{if legend (group-box) is in gtable, output them}

\item{use_cache}{use BiocFileCache for caching the image}

\item{high_res}{use 2x resolution image}

\item{res}{resolution parameter passed to saving the ggplot2 image}

\item{out}{output file name}

\item{directory}{specify if you have already downloaded the image}

\item{transparent_colors}{transparent colors}

\item{unlink}{unlink the intermediate image}

\item{with_legend_image}{append legend image instead of using gtable}

\item{legend_horiz}{append legend to the bottom of the image}

\item{legend_space}{legend spacing specification (in pixel)}
}
\value{
output the image and return the path
}
\description{
The function first exports the image, combine it with the original image.
Note that if the legend is outside the pathway image, the result will not 
show it correctly. Place the legend inside the panel by adding the theme 
such as theme(legend.position=c(0.5, 0.5)).
}
\details{
If the legend must be placed outside the image, the users can set 
with_legend_image to TRUE. This will create another legend only image
and concatenate it with the pathway image. legend_space option can be 
specified to control the spacing for the legend. If need to append horizontal
legend, enable legend_horiz option.

By default, unlink option is enabled which means the function will delete
the intermediate files.
}
\examples{
\dontrun{
    ouput_overlay_image(ggraph(pathway("hsa04110")))
} 


}
