% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight_functions.R
\name{highlight_set_edges}
\alias{highlight_set_edges}
\title{highlight_set_edges}
\usage{
highlight_set_edges(set, how = "all", name = "name", sep = " ", no_sep = FALSE)
}
\arguments{
\item{set}{set of identifiers}

\item{how}{if `all`, if node contains multiple
IDs separated by `sep`, highlight if all the IDs
are in query. if `any`, highlight if one of the IDs
is in query.}

\item{name}{which column to search for}

\item{sep}{separater for node names}

\item{no_sep}{not separate node name}
}
\value{
boolean vector
}
\description{
identify if edges are involved in specific query.
if multiple IDs are listed after separation by `sep`,
only return TRUE if all the IDs are in the query.
}
\examples{
graph <- create_test_pathway()

## Specify edge column by `name`
## In this example, edges having `degradation` value in
## `subtype_name` column will be highlighted
graph <- graph |> activate("edges") |>
    mutate(hl=highlight_set_edges(c("degradation"), name="subtype_name"))

}
