% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{assign_deseq2}
\alias{assign_deseq2}
\title{assign_deseq2}
\usage{
assign_deseq2(
  res,
  column = "log2FoldChange",
  gene_type = "SYMBOL",
  org_db = NULL,
  org = "hsa",
  numeric_combine = mean,
  name = "name",
  sep = " ",
  remove_dot = TRUE
)
}
\arguments{
\item{res}{The result() of DESeq()}

\item{column}{column of the numeric attribute, default to log2FoldChange}

\item{gene_type}{default to SYMBOL}

\item{org_db}{organism database to convert ID to ENTREZID}

\item{org}{organism ID in KEGG}

\item{numeric_combine}{how to combine multiple numeric values}

\item{name}{column name for ID in tbl_graph nodes}

\item{sep}{for node name}

\item{remove_dot}{remove dot in the name}
}
\value{
numeric vector
}
\description{
assign DESeq2 numerical values to nodes
}
\examples{
graph <- create_test_pathway()
res <- data.frame(row.names="6737",log2FoldChange=1.2)
graph <- graph |> mutate(num=assign_deseq2(res, gene_type="ENTREZID"))
}
