% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{append_cp}
\alias{append_cp}
\title{append_cp}
\usage{
append_cp(
  res,
  how = "any",
  name = "name",
  pid = NULL,
  infer = FALSE,
  sep = " ",
  remove_dot = TRUE
)
}
\arguments{
\item{res}{enrichResult class}

\item{how}{how to determine whether the nodes is in enrichment results}

\item{name}{name column to search for query}

\item{pid}{pathway ID, if NULL, try to infer from graph attribute}

\item{infer}{if TRUE, append the prefix to queried IDs based on pathway ID}

\item{sep}{separater for name}

\item{remove_dot}{remove dots in the name}
}
\value{
enrich_attribute column in node
}
\description{
append clusterProfiler results to graph
}
\examples{
graph <- create_test_pathway()
nodes <- graph |> data.frame()
if (require("clusterProfiler")) {
    cp <- enrichKEGG(nodes$name |>
            strsplit(":") |>
            vapply("[", 2, FUN.VALUE="character"))
    ## This append graph node logical value whether the 
    ## enriched genes are in pathway
    graph <- graph |> mutate(cp=append_cp(cp, pid="hsa05322"))
}
}
