% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_overlay.R
\name{geom_overlay}
\alias{geom_overlay}
\alias{geom_overlay.default}
\alias{geom_overlay.character}
\alias{geom_overlay.ncdfFlowList}
\alias{geom_overlay.flowSet}
\alias{geom_overlay.flowFrame}
\title{Overlay a population on an existing ggcyto plot analogous to backgating.}
\usage{
geom_overlay(data, ...)
}
\arguments{
\item{data}{a filter (Currently only rectangleGate (1d or 2d), polygonGate, ellipsoidGate are supported.)
or a list of these gates
or filterList
or character specifying a gated cell population in the GatingSet}

\item{...}{other arguments
mapping, The mapping aesthetic mapping
data a polygonGate
fill polygonGate is not filled by default
colour default is red
pd pData (data.frame) that has rownames represents the sample names used as key to be merged with filterList}
}
\value{
a geom_overlay layer
}
\description{
It is useful for "backgating" plots.
}
\examples{
library(ggcyto)
dataDir <- system.file("extdata",package="flowWorkspaceData")
gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE))
p <- autoplot(gs, "CD3+")

# add a flowSet as the overlay
fs <- gs_pop_get_data(gs, "DPT")
p + geom_overlay(data = fs, size = 0.3, alpha = 0.7)

# add overlay layer by gate name
p + geom_overlay(data = "DNT", size = 0.3, alpha = 0.7)

#add overlay for 1d densityplot
p <- ggcyto(gs, aes(x = CD4), subset = "CD3+") + geom_density(aes(y = ..count..))
p + geom_overlay("DNT", aes(y = ..count..), fill = "red")
}
