% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_plot.R
\name{.exp_plot}
\alias{.exp_plot}
\title{exp_plot}
\usage{
.exp_plot(input, rse, slot)
}
\arguments{
\item{input}{From ui.R}

\item{rse}{The rse object}

\item{slot}{which slot to pull the count data from the rse assay}
}
\value{
Returns a list with the $plot slot holding ggplot object and $grouping_length contains
the number of features to scale the plot
}
\description{
draws the expression box plot
}
\details{
Makes the box plot for the geyser Shiny app
}
\examples{

load(system.file('extdata/tiny_rse.Rdata', package = 'geyser'))
input <- list()
input$feature_col <- "row names"
input$features <- c("TYRP1 (ENSG00000107165.12)","OPN1LW (ENSG00000102076.9)")
input$groupings <- c('disease')
input$slot <- 'counts'
input$expression_scale <- TRUE
input$color_by <- 'tissue'
geyser:::.exp_plot(input, tiny_rse, 'counts')$plot
}
\author{
David McGaughey
}
\keyword{internal}
