% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDEE2.R
\name{query_bundles}
\alias{query_bundles}
\title{Query whether a project bundle is available from DEE2}
\usage{
query_bundles(species, query, col, bundles = NULL)
}
\arguments{
\item{species}{A character string matching a species of interest.}

\item{query}{A character string, such as  the SRA project accession number
or the GEO series accession number}

\item{col}{the column name to be queried, usually "SRP_accession" for SRA
project accession or "GSE_accession" for GEO series accession.}

\item{bundles}{optional table of previously downloaded bundles.}
}
\value{
a list of datasets that are present and absent.
}
\description{
This function sends a query to check whether a dataset is available or not.
}
\examples{
query_bundles("celegans", c("SRP133403","SRP133439"), col = "SRP_accession")
}
\keyword{query}
